/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class RecordV2Parser {
    RecordV2Parser() {
    }

    public List<List<String>> parse(byte[] bytes) {
        return this.parse(bytes, 0, bytes.length);
    }

    public List<List<String>> parse(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return Collections.emptyList();
        }
        if (length == 1 && bytes[offset] == 4) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        ArrayList<String> fields = new ArrayList<String>();
        int pos = offset;
        for (int i = offset; i < length; ++i) {
            if (bytes[i] == 1) {
                RecordV2Parser.processRecordDelimiter(bytes, records, pos, i, fields);
                pos = i + 1;
                continue;
            }
            if (bytes[i] != 2) continue;
            RecordV2Parser.addField(bytes, records, pos, i, fields);
            pos = i + 1;
        }
        RecordV2Parser.processEnd(bytes, records, pos, length, fields);
        return records;
    }

    private static void processRecordDelimiter(byte[] bytes, List<List<String>> records, int startPos, int endPos, List<String> fields) {
        boolean recordWritten = false;
        if (startPos < endPos) {
            recordWritten = RecordV2Parser.addField(bytes, records, startPos, endPos, fields);
        } else if (startPos > 0 && bytes[startPos - 1] == 2) {
            fields.add("");
        }
        if (!recordWritten) {
            records.add(new ArrayList<String>(fields));
        }
        fields.clear();
    }

    private static void processEnd(byte[] bytes, List<List<String>> records, int startPos, int endPos, List<String> fields) {
        if (endPos > startPos) {
            RecordV2Parser.addField(bytes, records, startPos, endPos, fields);
        } else {
            byte endByte = bytes[endPos - 1];
            if (endByte == 1) {
                records.add(Collections.emptyList());
            } else if (endByte == 2) {
                fields.add("");
            }
        }
        if (!fields.isEmpty()) {
            records.add(new ArrayList<String>(fields));
        }
    }

    private static boolean addField(byte[] bytes, List<List<String>> records, int startPos, int endPos, List<String> fields) {
        int len = endPos - startPos;
        if (fields.isEmpty() && len == 1 && bytes[startPos] == 5) {
            records.add(Collections.singletonList(""));
            return true;
        }
        fields.add(CharsetUtils.bytesUTF8ToString(bytes, startPos, len));
        return false;
    }
}

