/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.recordv2.impl;

import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DeltaType;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2Delta;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2DeltaImpl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Impl;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2Utils;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class RecordV2DeltaType
implements DeltaType<RecordV2, RecordV2Delta> {
    @Override
    public String getName() {
        return "delta";
    }

    @Override
    public void writeDelta(RecordV2Delta delta, OutputStream out) throws IOException {
        this.toBytes(delta).copyTo(out);
    }

    public IBytes toBytes(RecordV2Delta delta) {
        return (RecordV2DeltaImpl)delta;
    }

    @Override
    public RecordV2DeltaImpl readDelta(byte[] in, int offset, int length) throws InvalidDataException, IndexOutOfBoundsException {
        return new RecordV2DeltaImpl(in, offset, length);
    }

    @Override
    public RecordV2DeltaImpl readDelta(byte[] in) throws InvalidDataException {
        return new RecordV2DeltaImpl(in);
    }

    @Override
    public RecordV2DeltaImpl readDelta(Bytes bytes) {
        return this.readDelta(IBytes.toByteArray(bytes));
    }

    @Override
    public RecordV2Delta diff(RecordV2 oldValue, RecordV2 newValue) throws InvalidDataException {
        return newValue.diff(oldValue);
    }

    @Override
    public RecordV2Delta noChange() {
        return RecordV2DeltaImpl.NO_CHANGE;
    }

    @Override
    public boolean isValueCheaper(RecordV2 value, RecordV2Delta delta) throws InvalidDataException {
        return value.length() < ((RecordV2DeltaImpl)delta).length();
    }

    @Override
    public RecordV2 apply(RecordV2 oldValue, RecordV2Delta delta) throws InvalidDataException {
        RecordV2DeltaImpl deltaImpl = (RecordV2DeltaImpl)delta;
        if (deltaImpl.length() == 0) {
            return RecordV2Impl.EMPTY_VALUE;
        }
        if (deltaImpl.length() == 1 && deltaImpl.bytes()[deltaImpl.offset()] == 4) {
            return RecordV2Impl.RECORD_MU_VALUE;
        }
        RecordV2Impl value = (RecordV2Impl)oldValue;
        try {
            return RecordV2DeltaType.applyDelta(value.bytes(), value.offset(), value.length(), deltaImpl.bytes(), deltaImpl.offset(), deltaImpl.length());
        }
        catch (IOException ex) {
            throw new InvalidDataException(ex);
        }
    }

    private static RecordV2 applyDelta(byte[] vBytes, int vOffset, int vLength, byte[] dBytes, int dOffset, int dLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (vLength == 0 || vLength == 1 && vBytes[vOffset] == 4) {
            RecordV2DeltaType.copyRemainingDelta(dBytes, dOffset, dLength, out);
            byte[] recordBytes = out.toByteArray();
            return new RecordV2Impl(recordBytes);
        }
        int vCount = RecordV2Utils.recordCount(vBytes, vOffset, vLength);
        int dCount = RecordV2Utils.recordCount(dBytes, dOffset, dLength);
        int same = Math.min(vCount, dCount);
        int vStart = vOffset;
        int vEnd = vOffset;
        int dStart = dOffset;
        int dEnd = dOffset;
        boolean delimiter = false;
        for (int i = 0; i < same; ++i) {
            vEnd = RecordV2Utils.findDelimiter(vBytes, vEnd, vOffset + vLength, (byte)1);
            dEnd = RecordV2Utils.findDelimiter(dBytes, dEnd, dOffset + dLength, (byte)1);
            if (delimiter) {
                out.write(1);
            } else {
                delimiter = true;
            }
            RecordV2DeltaType.applyRecordDelta(vBytes, vStart, vEnd - vStart, dBytes, dStart, dEnd - dStart, out);
            vStart = ++vEnd;
            dStart = ++dEnd;
        }
        if (dCount > vCount) {
            out.write(dBytes, dStart - 1, dOffset + dLength - dStart + 1);
        }
        return new RecordV2Impl(out.toByteArray());
    }

    private static void applyRecordDelta(byte[] vBytes, int vOffset, int vLength, byte[] dBytes, int dOffset, int dLength, ByteArrayOutputStream out) throws IOException {
        if (dLength == 0) {
            return;
        }
        if (dLength == 1 && dBytes[dOffset] == 5) {
            out.write(5);
            return;
        }
        if (dLength == 1 && dBytes[dOffset] == 3) {
            int endPos = RecordV2Utils.findDelimiter(vBytes, vOffset, vOffset + vLength, (byte)2);
            out.write(vBytes, vOffset, endPos - vOffset);
            return;
        }
        if (vLength == 0 || RecordV2Utils.recordIsSingleEmptyField(vBytes, vOffset, vLength)) {
            RecordV2DeltaType.copyRemainingDelta(dBytes, dOffset, dLength, out);
            return;
        }
        RecordV2DeltaType.applyRecordFields(vBytes, vOffset, vLength, dBytes, dOffset, dLength, out);
    }

    private static void applyRecordFields(byte[] vBytes, int vOffset, int vLength, byte[] dBytes, int dOffset, int dLength, ByteArrayOutputStream out) throws IOException {
        int fieldCount = RecordV2Utils.fieldCount(vBytes, vOffset, vLength);
        int deltaFieldCount = RecordV2Utils.fieldCount(dBytes, dOffset, dLength);
        int same = Math.min(fieldCount, deltaFieldCount);
        int vStart = vOffset;
        int vEnd = vOffset;
        int dStart = dOffset;
        int dEnd = dOffset;
        boolean delimiter = false;
        for (int i = 0; i < same; ++i) {
            vEnd = RecordV2Utils.findDelimiter(vBytes, vEnd, vOffset + vLength, (byte)2);
            dEnd = RecordV2Utils.findDelimiter(dBytes, dEnd, dOffset + dLength, (byte)2);
            if (delimiter) {
                out.write(2);
            } else {
                delimiter = true;
            }
            RecordV2DeltaType.applyDeltaField(vBytes, vStart, vEnd - vStart, dBytes, dStart, dEnd - dStart, out);
            vStart = ++vEnd;
            dStart = ++dEnd;
        }
        if (deltaFieldCount > fieldCount) {
            RecordV2DeltaType.copyRemainingDelta(dBytes, dStart - 1, dOffset + dLength - dStart + 1, out);
        }
    }

    private static void applyDeltaField(byte[] vBytes, int vOffset, int vLength, byte[] dBytes, int dOffset, int dLength, ByteArrayOutputStream out) throws IOException {
        if (dLength == 0) {
            out.write(vBytes, vOffset, vLength);
        } else if (dLength != 1 || dBytes[dOffset] != 3) {
            out.write(dBytes, dOffset, dLength);
        }
    }

    private static void copyRemainingDelta(byte[] bytes, int offset, int length, ByteArrayOutputStream out) {
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            if (b == 3) continue;
            out.write(b);
        }
    }
}

