/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.primitive.impl;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.mqtt.MQTTUTF8;
import com.pushtechnology.diffusion.datatype.primitive.impl.CborCodec;
import com.pushtechnology.diffusion.datatype.primitive.impl.PrimitiveDataTypeImpl;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.IOException;
import net.jcip.annotations.Immutable;

@Immutable
public final class Int64DataTypeImpl
extends PrimitiveDataTypeImpl<Long> {
    public Int64DataTypeImpl() {
        super("int64", Long.class, CborCodec::encodeInteger, CborCodec::decodeInteger, Int64DataTypeImpl::toMQTTUTF8, false);
    }

    private static MQTTUTF8 toMQTTUTF8(byte[] bs, int o, int l) {
        long v;
        if (Int64DataTypeImpl.isCBORNull(bs, o, l)) {
            return null;
        }
        try {
            v = CborCodec.decodeInteger(bs, o, l);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        return new MQTTUTF8(CharsetUtils.stringToBytesUTF8(Long.toString(v)));
    }
}

