/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.primitive.impl;

import com.pushtechnology.diffusion.datatype.internal.SupplierFromBytes;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.diffusion.utils.FastEncoder;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class CborCodec {
    private CborCodec() {
    }

    public static void encodeDouble(OutputStream out, double value) throws IOException {
        long l = Double.doubleToRawLongBits(value);
        out.write(-5);
        out.write((byte)(l >> 56));
        out.write((byte)(l >> 48));
        out.write((byte)(l >> 40));
        out.write((byte)(l >> 32));
        out.write((byte)(l >> 24));
        out.write((byte)(l >> 16));
        out.write((byte)(l >> 8));
        out.write((byte)l);
    }

    public static double decodeDouble(byte[] bytes) throws IOException {
        return CborCodec.decodeDouble(bytes, 0, bytes.length);
    }

    public static double decodeDouble(byte[] bytes, int offset, int length) throws IOException {
        if (length != 9) {
            throw new IOException("Invalid double encoding. Expected 9 bytes, got " + length);
        }
        if (bytes[offset] != -5) {
            throw new IOException("Invalid double encoding. Type byte: " + bytes[offset]);
        }
        long l = CborCodec.decodeUint64LengthUnchecked(bytes, offset);
        return Double.longBitsToDouble(l);
    }

    public static void encodeString(OutputStream out, String value) throws IOException {
        int length = FastEncoder.utf8Length(value);
        CborCodec.encodeInteger(out, length, 96);
        FastEncoder.utf8Encode(value, out);
    }

    public static String decodeString(byte[] bytes) throws IOException {
        return CborCodec.decodeString(bytes, 0, bytes.length, CharsetUtils::bytesUTF8ToString);
    }

    public static <R> R decodeString(byte[] bytes, int offset, int length, SupplierFromBytes<R> fn) throws IOException {
        int utf8Length;
        int utf8Offset;
        if (length < 1) {
            throw new IOException("Empty bytes");
        }
        byte b = bytes[offset];
        byte typePrefix = (byte)(b & 0xE0);
        if (typePrefix != 96) {
            throw new IOException("Non-text CBOR type byte: " + b);
        }
        int additionalInformation = b & 0x1F;
        if (additionalInformation < 24) {
            utf8Offset = 1;
            utf8Length = additionalInformation;
        } else if (additionalInformation == 24) {
            utf8Offset = 2;
            CborCodec.checkAtLeast(2, bytes);
            utf8Length = CborCodec.decodeUint8LengthUnchecked(bytes, offset);
        } else if (additionalInformation == 25) {
            utf8Offset = 3;
            CborCodec.checkAtLeast(3, bytes);
            utf8Length = CborCodec.decodeUint16LengthUnchecked(bytes, offset);
        } else if (additionalInformation == 26) {
            utf8Offset = 5;
            CborCodec.checkAtLeast(5, bytes);
            utf8Length = CborCodec.decodeUint32LengthUnchecked(bytes, offset);
        } else {
            throw new IOException("Invalid CBOR type byte: " + b);
        }
        if (utf8Length != length - utf8Offset) {
            throw new IOException("Received " + length + " bytes, with type code " + bytes[0] + " implying text length of " + (bytes.length - utf8Offset) + " but encoded text length is " + utf8Length);
        }
        return fn.get(bytes, utf8Offset, utf8Length);
    }

    public static void encodeInteger(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            CborCodec.encodeInteger(out, -value - 1L, 32);
        } else {
            CborCodec.encodeInteger(out, value, 0);
        }
    }

    private static void encodeInteger(OutputStream out, long i, int marker) throws IOException {
        if (i < 24L) {
            out.write((byte)((long)marker + i));
        } else if (i <= 255L) {
            CborCodec.encodeUint8(out, i, marker);
        } else if (i <= 65535L) {
            CborCodec.encodeUint16(out, i, marker);
        } else if (i <= 0xFFFFFFFFL) {
            CborCodec.encodeUint32(out, i, marker);
        } else {
            CborCodec.encodeUinit64(out, i, marker);
        }
    }

    private static void encodeUint8(OutputStream out, long i, int marker) throws IOException {
        out.write((byte)(marker + 24));
        out.write((byte)i);
    }

    private static void encodeUint16(OutputStream out, long i, int marker) throws IOException {
        out.write((byte)(marker + 25));
        out.write((byte)(i >> 8));
        out.write((byte)i);
    }

    private static void encodeUint32(OutputStream out, long i, int marker) throws IOException {
        out.write((byte)(marker + 26));
        out.write((byte)(i >> 24));
        out.write((byte)(i >> 16));
        out.write((byte)(i >> 8));
        out.write((byte)i);
    }

    private static void encodeUinit64(OutputStream out, long i, int marker) throws IOException {
        out.write((byte)(marker + 27));
        out.write((byte)(i >> 56));
        out.write((byte)(i >> 48));
        out.write((byte)(i >> 40));
        out.write((byte)(i >> 32));
        out.write((byte)(i >> 24));
        out.write((byte)(i >> 16));
        out.write((byte)(i >> 8));
        out.write((byte)i);
    }

    public static long decodeInteger(byte[] bytes) throws IOException {
        return CborCodec.decodeInteger(bytes, 0, bytes.length);
    }

    public static long decodeInteger(byte[] bytes, int offset, int length) throws IOException {
        if (length < 1) {
            throw new IOException("Empty bytes");
        }
        byte b = bytes[offset];
        byte additionalInformation = (byte)(b & 0x1F);
        if (additionalInformation < 24) {
            CborCodec.checkLength(length, 1);
            return CborCodec.toSigned(b, additionalInformation);
        }
        if (additionalInformation == 24) {
            return CborCodec.decodeUint8(bytes, offset, length);
        }
        if (additionalInformation == 25) {
            return CborCodec.decodeUint16(bytes, offset, length);
        }
        if (additionalInformation == 26) {
            return CborCodec.decodeUint32(bytes, offset, length);
        }
        if (additionalInformation == 27) {
            return CborCodec.decodeUint64(bytes, offset, length);
        }
        throw new IOException("Invalid CBOR type byte: " + b);
    }

    private static long decodeUint8(byte[] bytes, int offset, int length) throws IOException {
        CborCodec.checkLength(length, 2);
        return CborCodec.toSigned(bytes[offset], CborCodec.decodeUint8LengthUnchecked(bytes, offset));
    }

    private static int decodeUint8LengthUnchecked(byte[] bytes, int offset) {
        return CborCodec.unsignedShiftInt(bytes[offset + 1], 0);
    }

    private static long decodeUint16(byte[] bytes, int offset, int length) throws IOException {
        CborCodec.checkLength(length, 3);
        return CborCodec.toSigned(bytes[offset], CborCodec.decodeUint16LengthUnchecked(bytes, offset));
    }

    private static int decodeUint16LengthUnchecked(byte[] bytes, int offset) {
        return CborCodec.unsignedShiftInt(bytes[offset + 1], 8) + CborCodec.unsignedShiftInt(bytes[offset + 2], 0);
    }

    private static long decodeUint32(byte[] bytes, int offset, int length) throws IOException {
        CborCodec.checkLength(length, 5);
        return CborCodec.toSigned(bytes[offset], CborCodec.decodeUint32LengthUnchecked(bytes, offset));
    }

    private static int decodeUint32LengthUnchecked(byte[] bytes, int offset) {
        return CborCodec.unsignedShiftInt(bytes[offset + 1], 24) + CborCodec.unsignedShiftInt(bytes[offset + 2], 16) + CborCodec.unsignedShiftInt(bytes[offset + 3], 8) + CborCodec.unsignedShiftInt(bytes[offset + 4], 0);
    }

    private static long decodeUint64(byte[] bytes, int offset, int length) throws IOException {
        CborCodec.checkLength(length, 9);
        return CborCodec.toSigned(bytes[offset], CborCodec.decodeUint64LengthUnchecked(bytes, offset));
    }

    private static long decodeUint64LengthUnchecked(byte[] bytes, int offset) {
        return CborCodec.unsignedShiftLong(bytes[offset + 1], 56) + CborCodec.unsignedShiftLong(bytes[offset + 2], 48) + CborCodec.unsignedShiftLong(bytes[offset + 3], 40) + CborCodec.unsignedShiftLong(bytes[offset + 4], 32) + CborCodec.unsignedShiftLong(bytes[offset + 5], 24) + CborCodec.unsignedShiftLong(bytes[offset + 6], 16) + CborCodec.unsignedShiftLong(bytes[offset + 7], 8) + CborCodec.unsignedShiftLong(bytes[offset + 8], 0);
    }

    private static int unsignedShiftInt(byte b, int bits) {
        int u = b & 0xFF;
        return u << bits;
    }

    private static long unsignedShiftLong(byte b, int bits) {
        long u = b & 0xFF;
        return u << bits;
    }

    private static void checkLength(int length, int expected) throws IOException {
        if (expected != length) {
            throw new IOException("Expected " + expected + " bytes but received " + length + " bytes");
        }
    }

    private static void checkAtLeast(int wanted, byte[] bytes) throws IOException {
        if (wanted > bytes.length) {
            throw new IOException("Expected at least " + wanted + " bytes but received " + bytes.length + " bytes");
        }
    }

    private static long toSigned(byte b, long v) throws IOException {
        byte typePrefix = (byte)(b & 0xE0);
        if (typePrefix == 0) {
            return v;
        }
        if (typePrefix == 32) {
            return -1L - v;
        }
        throw new IOException("Non-integer CBOR type byte: " + b);
    }
}

