/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import com.pushtechnology.diffusion.datatype.json.impl.JSONPointer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class JSONPointerMap<T>
implements Iterable<Entry> {
    private static final JSONPointerMap<Object> EMPTY = new JSONPointerMap();
    private final Entry root = new Entry(null, JSONPointer.ROOT);
    private int size;

    public T put(JSONPointer pointer, T value) {
        T v = Objects.requireNonNull(value);
        Iterator<JSONPointer.Segment> i = pointer.segments().iterator();
        Entry node = this.root;
        while (i.hasNext()) {
            JSONPointer.Segment s = i.next();
            Entry c = node.findChild(s);
            if (c == null) {
                node = node.addChild(s);
                break;
            }
            node = c;
        }
        while (i.hasNext()) {
            node = node.addChild(i.next());
        }
        return node.setValue(v);
    }

    public boolean contains(JSONPointer pointer) {
        return this.get(pointer) != null;
    }

    public T get(JSONPointer pointer) {
        Entry n = this.getEntry(pointer);
        if (n != null) {
            return n.getValue();
        }
        return null;
    }

    public Entry getEntry(JSONPointer pointer) {
        Entry result = this.root;
        for (JSONPointer.Segment s : pointer.segments()) {
            if ((result = result.findChild(s)) != null) continue;
            return null;
        }
        return result;
    }

    JSONPointerMap<T> descendants(JSONPointer pointer) {
        List<JSONPointer.Segment> segments = pointer.segments();
        int n = segments.size();
        if (n == 0) {
            return this;
        }
        Entry thisNode = this.root;
        JSONPointerMap<T> result = new JSONPointerMap<T>();
        Entry resultNode = result.root;
        for (int i = 0; i < n - 1; ++i) {
            JSONPointer.Segment s = segments.get(i);
            if ((thisNode = thisNode.findChild(s)) == null) {
                return JSONPointerMap.empty();
            }
            resultNode = resultNode.addChild(s);
        }
        Entry last = thisNode.findChild(segments.get(n - 1));
        if (last == null) {
            return JSONPointerMap.empty();
        }
        resultNode.children.add(last);
        result.size = last.count();
        return result;
    }

    JSONPointerMap<T> intersection(JSONPointer pointer) {
        List<JSONPointer.Segment> segments = pointer.segments();
        int n = segments.size();
        if (n == 0) {
            return this;
        }
        Entry thisNode = this.root;
        JSONPointerMap<T> result = new JSONPointerMap<T>();
        Entry resultNode = result.root;
        if (thisNode.value != null) {
            resultNode.setValue(thisNode.value);
        }
        for (int i = 0; i < n - 1; ++i) {
            JSONPointer.Segment s = segments.get(i);
            if ((thisNode = thisNode.findChild(s)) == null) {
                return result;
            }
            resultNode = resultNode.addChild(s);
            if (thisNode.value == null) continue;
            resultNode.setValue(thisNode.value);
        }
        Entry last = thisNode.findChild(segments.get(n - 1));
        if (last == null) {
            return result;
        }
        resultNode.children.add(last);
        result.size += last.count();
        return result;
    }

    private static <T> JSONPointerMap<T> empty() {
        return EMPTY;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Entry> iterator() {
        final ArrayDeque<Entry> stack = new ArrayDeque<Entry>();
        stack.push(this.root);
        return new AbstractEntryIterator(){

            @Override
            protected Entry nextWithValue() {
                Entry r;
                do {
                    if ((r = (Entry)stack.poll()) == null) {
                        return null;
                    }
                    ListIterator<Entry> reverseChildren = r.children.listIterator(r.children.size());
                    while (reverseChildren.hasPrevious()) {
                        stack.push(reverseChildren.previous());
                    }
                } while (r.value == null);
                return r;
            }
        };
    }

    public Iterator<Entry> postOrder() {
        final ArrayDeque<PostOrderState> stack = new ArrayDeque<PostOrderState>();
        stack.push(new PostOrderState(this.root));
        return new AbstractEntryIterator(){

            @Override
            protected Entry nextWithValue() {
                PostOrderState r;
                while ((r = (PostOrderState)stack.peek()) != null) {
                    Entry c = r.nextChild();
                    if (c == null) {
                        stack.pop();
                        if (r.node.value == null) continue;
                        return r.node;
                    }
                    if (c.children.isEmpty()) {
                        assert (c.value != null);
                        return c;
                    }
                    stack.push(new PostOrderState(c));
                }
                return null;
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size * 10);
        sb.append('{');
        Iterator<Entry> x = this.iterator();
        while (x.hasNext()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(x.next());
        }
        sb.append('}');
        return sb.toString();
    }

    @NotThreadSafe
    public final class Entry {
        private final JSONPointer.Segment segment;
        private final JSONPointer pointer;
        private T value;
        private final List<Entry> children = new ArrayList<Entry>();

        private Entry(JSONPointer.Segment segment, JSONPointer pointer) {
            this.segment = segment;
            this.pointer = pointer;
        }

        private int count() {
            int result = this.value != null ? 1 : 0;
            for (Entry c : this.children) {
                result += c.count();
            }
            return result;
        }

        private Entry addChild(JSONPointer.Segment s) {
            Entry c = new Entry(s, this.pointer.withSegment(s));
            this.children.add(c);
            return c;
        }

        private Entry findChild(JSONPointer.Segment s) {
            for (Entry c : this.children) {
                if (!s.equals(c.segment)) continue;
                return c;
            }
            return null;
        }

        public JSONPointer getPointer() {
            return this.pointer;
        }

        public T getValue() {
            return this.value;
        }

        public T setValue(T newValue) {
            Object previous = this.value;
            this.value = Objects.requireNonNull(newValue);
            if (previous == null) {
                ++JSONPointerMap.this.size;
            }
            return previous;
        }

        public int removeDescendants() {
            int removed = 0;
            for (Entry c : this.children) {
                removed += c.count();
            }
            this.children.clear();
            JSONPointerMap.this.size -= removed;
            return removed;
        }

        public int numberOfChildren() {
            int result = 0;
            for (Entry c : this.children) {
                result += c.value != null ? 1 : 0;
            }
            return result;
        }

        public String toString() {
            return String.valueOf(this.pointer) + "=" + String.valueOf(this.value);
        }
    }

    @NotThreadSafe
    private final class PostOrderState {
        private final Entry node;
        private int nextChild = 0;

        PostOrderState(Entry node) {
            this.node = node;
        }

        public Entry nextChild() {
            List<Entry> children = this.node.children;
            if (this.nextChild >= children.size()) {
                return null;
            }
            return children.get(this.nextChild++);
        }
    }

    private abstract class AbstractEntryIterator
    implements Iterator<Entry> {
        private Entry next = this.nextWithValue();

        private AbstractEntryIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final Entry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Entry result = this.next;
            this.next = this.nextWithValue();
            return result;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract Entry nextWithValue();
    }
}

