/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import java.util.Arrays;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class JSONPointer {
    public static final JSONPointer ROOT = new JSONPointer(new Segment[0]);
    private final Segment[] segments;

    public static JSONPointer parse(String expression) {
        JSONPointer result = ROOT;
        if (expression.isEmpty()) {
            return result;
        }
        Parser segmentParser = new Parser(expression);
        Segment s;
        while ((s = segmentParser.next()) != null) {
            result = result.withSegment(s);
        }
        return result;
    }

    private JSONPointer(Segment[] nodes) {
        this.segments = nodes;
    }

    public JSONPointer withKey(String key) {
        return this.withSegment(new Segment(key));
    }

    public JSONPointer withIndex(int index) {
        return this.withSegment(new Segment(index));
    }

    JSONPointer withSegment(Segment newNode) {
        int l = this.segments.length;
        Segment[] newNodes = Arrays.copyOf(this.segments, l + 1);
        newNodes[l] = newNode;
        return new JSONPointer(newNodes);
    }

    public List<Segment> segments() {
        return Arrays.asList(this.segments);
    }

    public Segment lastSegment() {
        return this.segments.length == 0 ? null : this.segments[this.segments.length - 1];
    }

    public JSONPointer parent() {
        return this.segments.length == 0 ? this : new JSONPointer(Arrays.copyOf(this.segments, this.segments.length - 1));
    }

    public boolean equalIgnoringIndexes(JSONPointer other) {
        if (other == this) {
            return true;
        }
        int length = this.segments.length;
        if (length != other.segments.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Segment s = this.segments[i];
            Segment o = other.segments[i];
            if (!(s.index() >= 0 ? o.index() < 0 : !s.equals(o))) continue;
            return false;
        }
        return true;
    }

    public JSONPointer join(JSONPointer pointer) {
        int currentLength = this.segments.length;
        if (currentLength == 0) {
            return pointer;
        }
        int newLength = pointer.segments.length;
        if (newLength == 0) {
            return this;
        }
        Segment[] result = Arrays.copyOf(this.segments, currentLength + newLength);
        System.arraycopy(pointer.segments, 0, result, currentLength, newLength);
        return new JSONPointer(result);
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        JSONPointer other = (JSONPointer)o;
        return Arrays.deepEquals(this.segments, other.segments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.segments.length * 10);
        for (Segment s : this.segments) {
            sb.append('/');
            JSONPointer.escape(s.key(), sb);
        }
        return sb.toString();
    }

    private static void escape(String key, StringBuilder result) {
        int length = key.length();
        for (int i = 0; i < length; ++i) {
            char c = key.charAt(i);
            if (c != '/' && c != '~') continue;
            result.append(key, 0, i);
            for (int j = i; j < length; ++j) {
                char c1 = key.charAt(j);
                if (c1 == '/') {
                    result.append("~1");
                    continue;
                }
                if (c1 == '~') {
                    result.append("~0");
                    continue;
                }
                result.append(c1);
            }
            return;
        }
        result.append(key);
    }

    private static final class Parser {
        private final String expression;
        private int p;

        Parser(String expression) {
            if (expression.charAt(0) != '/') {
                throw new IllegalArgumentException("JSON Pointer expression must be empty or start with '/': \"" + expression + "\"");
            }
            this.expression = expression;
            this.p = 0;
        }

        public Segment next() {
            if (this.p == this.expression.length()) {
                return null;
            }
            ++this.p;
            return this.nextSegment();
        }

        private Segment nextSegment() {
            char c;
            int start = this.p;
            long index = 0L;
            while (this.p < this.expression.length() && (c = this.expression.charAt(this.p)) != '/') {
                if (c == '~') {
                    return this.nextSegmentEscaped(start);
                }
                if (index != -1L) {
                    if (c < '0' || c > '9' || this.p != start && index == 0L) {
                        index = -1L;
                    } else if ((index = index * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        index = -1L;
                    }
                }
                ++this.p;
            }
            return this.toSegment(start, index);
        }

        private Segment toSegment(int start, long index) {
            return start != this.p && index != -1L ? new Segment((int)index) : new Segment(this.expression.substring(start, this.p));
        }

        private Segment nextSegmentEscaped(int start) {
            char c1;
            StringBuilder sb = new StringBuilder();
            sb.append(this.expression, start, this.p);
            int length = this.expression.length();
            while (this.p < length && (c1 = this.expression.charAt(this.p)) != '/') {
                if (c1 == '~' && this.p != length - 1) {
                    ++this.p;
                    char c2 = this.expression.charAt(this.p);
                    if (c2 == '0') {
                        sb.append('~');
                    } else if (c2 == '1') {
                        sb.append('/');
                    } else {
                        sb.append('~');
                        sb.append(c2);
                    }
                } else {
                    sb.append(c1);
                }
                ++this.p;
            }
            return new Segment(sb.toString());
        }
    }

    @Immutable
    public static final class Segment {
        private final String key;
        private final int index;

        private Segment(String key) {
            this(key, -1);
        }

        private Segment(int index) {
            this(Integer.toString(index), index);
        }

        private Segment(String key, int index) {
            this.key = key;
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public String key() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment other = (Segment)o;
            return this.key.equals(other.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

