/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.io.bytes.AbstractIBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayUtilities;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesInputStream;
import com.pushtechnology.diffusion.utils.string.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
public final class DeltaModifiedIBytes
extends AbstractIBytes {
    private final IBytes theValue;
    private final InternalBinaryDelta theDelta;
    private final int theLength;

    public static IBytes create(IBytes iBytes, InternalBinaryDelta delta) {
        if (!delta.hasChanges()) {
            return iBytes;
        }
        BinaryDeltaParser parser = delta.createParser();
        int[] lens = new int[]{0};
        while (parser.next((s, l) -> {
            if (s + l > iBytes.length()) {
                throw new IndexOutOfBoundsException("delta references range beyond value length");
            }
            lens[0] = lens[0] + l;
        }, (b, o, l) -> {
            lens[0] = lens[0] + l;
        })) {
        }
        return new DeltaModifiedIBytes(iBytes, delta, lens[0]);
    }

    private DeltaModifiedIBytes(IBytes value, InternalBinaryDelta delta, int length) {
        this.theValue = value;
        this.theDelta = delta;
        this.theLength = length;
    }

    @Override
    public int length() {
        return this.theLength;
    }

    @Override
    public IBytesInputStream asInputStream() {
        return new DeltaModifiedIBytesInputStream();
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[this.theLength];
        try (DeltaModifiedIBytesInputStream in = new DeltaModifiedIBytesInputStream();){
            int bytesRead = in.read(bytes);
            assert (bytesRead == this.theLength);
        }
        return bytes;
    }

    @Override
    public void copyTo(OutputStream target) throws IOException {
        target.write(this.toByteArray());
    }

    @Override
    public void copyTo(ByteBuffer buffer) throws BufferOverflowException, ReadOnlyBufferException {
        try (DeltaModifiedIBytesInputStream in = new DeltaModifiedIBytesInputStream();){
            in.read(buffer);
        }
    }

    @Override
    public void appendHex(StringBuilder sb, int limit) {
        int len = Math.min(this.theLength, limit);
        byte[] bytes = new byte[len];
        try (DeltaModifiedIBytesInputStream in = new DeltaModifiedIBytesInputStream();){
            int bytesRead = in.read(bytes);
            assert (bytesRead == len);
        }
        StringUtils.appendHex(sb, bytes, 0, len);
    }

    @NotThreadSafe
    private final class DeltaModifiedIBytesInputStream
    extends IBytesInputStream {
        private final BinaryDeltaParser parser;
        private final IBytesInputStream valueStream;
        private int resultPos;
        private byte[] insertBytes;
        private int pos;
        private int endPos;
        private DeltaState deltaState;
        private Mark mark;

        private DeltaModifiedIBytesInputStream() {
            this.parser = DeltaModifiedIBytes.this.theDelta.createParser();
            this.valueStream = DeltaModifiedIBytes.this.theValue.asInputStream();
            this.resultPos = 0;
            this.readDelta();
        }

        @Override
        public int read() {
            if (this.available() == 0) {
                return -1;
            }
            while (true) {
                if (this.pos < this.endPos) {
                    int b = this.deltaState == DeltaState.MATCH ? this.valueStream.read() : this.insertBytes[this.pos] & 0xFF;
                    ++this.pos;
                    ++this.resultPos;
                    return b;
                }
                this.readDelta();
            }
        }

        @Override
        public int read(byte[] bytes, int offset, int length) {
            int bytesRead;
            if (this.available() == 0) {
                return -1;
            }
            ArrayUtilities.checkBounds(bytes, offset, length);
            int bytesToRead = Math.min(length, this.available());
            for (int bytesReadSoFar = 0; bytesReadSoFar < bytesToRead; bytesReadSoFar += bytesRead) {
                bytesRead = this.readIntoByteArray(bytes, offset + bytesReadSoFar, bytesToRead - bytesReadSoFar);
            }
            return bytesToRead;
        }

        private int readIntoByteArray(byte[] bytes, int offset, int length) {
            if (this.endPos == this.pos) {
                this.readDelta();
                assert (this.endPos != this.pos);
            }
            int bytesToRead = Math.min(this.endPos - this.pos, length);
            if (this.deltaState == DeltaState.MATCH) {
                int bytesRead = this.valueStream.read(bytes, offset, bytesToRead);
                assert (bytesRead == bytesToRead);
            } else {
                System.arraycopy(this.insertBytes, this.pos, bytes, offset, bytesToRead);
            }
            this.pos += bytesToRead;
            this.resultPos += bytesToRead;
            return bytesToRead;
        }

        @Override
        public int read(ByteBuffer buffer, int length) {
            int bytesRead;
            if (this.available() == 0) {
                return 0;
            }
            int bytesToRead = Math.min(length, this.available());
            for (int bytesReadSoFar = 0; bytesReadSoFar < bytesToRead; bytesReadSoFar += bytesRead) {
                bytesRead = this.readIntoByteBuffer(buffer, bytesToRead - bytesReadSoFar);
            }
            return bytesToRead;
        }

        private int readIntoByteBuffer(ByteBuffer buffer, int length) {
            if (this.endPos == this.pos) {
                this.readDelta();
                assert (this.endPos != this.pos);
            }
            int bytesToRead = Math.min(this.endPos - this.pos, length);
            if (this.deltaState == DeltaState.MATCH) {
                int bytesRead = this.valueStream.read(buffer, bytesToRead);
                assert (bytesRead == bytesToRead);
            } else {
                buffer.put(this.insertBytes, this.pos, bytesToRead);
            }
            this.pos += bytesToRead;
            this.resultPos += bytesToRead;
            return bytesToRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBytes toBytes(int length) {
            int remaining = Math.min(length, this.available());
            if (remaining == 0) {
                return IBytes.EMPTY_BYTES;
            }
            if (remaining == DeltaModifiedIBytes.this.theLength) {
                return DeltaModifiedIBytes.this;
            }
            Mark m = this.recordMark();
            try {
                byte[] bytes = new byte[remaining];
                this.read(bytes, 0, remaining);
                IBytes iBytes = IBytes.toIBytes(bytes);
                return iBytes;
            }
            finally {
                this.resetToMark(m);
            }
        }

        @Override
        public long skip(long length) {
            int bytesSkipped;
            if (this.available() == 0) {
                return 0L;
            }
            int bytesToSkip = Math.min((int)length, this.available());
            for (int bytesSkippedSoFar = 0; bytesSkippedSoFar < bytesToSkip; bytesSkippedSoFar += bytesSkipped) {
                bytesSkipped = this.skipNext(bytesToSkip - bytesSkippedSoFar);
            }
            return bytesToSkip;
        }

        private int skipNext(int length) {
            int bytesLeft = this.endPos - this.pos;
            if (bytesLeft == 0) {
                this.readDelta();
                return this.skipNext(length);
            }
            int bytesToSkip = Math.min(bytesLeft, length);
            if (this.deltaState == DeltaState.MATCH) {
                int bytesSkipped = (int)this.valueStream.skip(bytesToSkip);
                assert (bytesSkipped == bytesToSkip);
            }
            this.pos += bytesToSkip;
            this.resultPos += bytesToSkip;
            return bytesToSkip;
        }

        @Override
        public int available() {
            return DeltaModifiedIBytes.this.theLength - this.resultPos;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.recordMark();
        }

        @Override
        public void reset() {
            this.resetToMark(this.mark);
        }

        @Override
        public Mark recordMark() {
            return new Mark(this.resultPos, this.insertBytes, this.pos, this.endPos, this.deltaState, this.parser.mark(), this.valueStream.recordMark());
        }

        @Override
        public void resetToMark(Object o) {
            Mark m = (Mark)o;
            this.resultPos = m.resultPos;
            this.insertBytes = m.insertBytes;
            this.pos = m.pos;
            this.endPos = m.endPos;
            this.deltaState = m.deltaState;
            this.parser.reset(m.parserMark);
            this.valueStream.resetToMark(m.valueStreamMark);
        }

        private void readDelta() {
            if (!this.parser.next((s, l) -> {
                this.deltaState = DeltaState.MATCH;
                this.pos = s;
                this.endPos = this.pos + l;
                long toSkip = this.pos - (DeltaModifiedIBytes.this.theValue.length() - this.valueStream.available());
                long skipped = this.valueStream.skip(toSkip);
                assert (skipped == toSkip);
            }, (b, o, l) -> {
                this.deltaState = DeltaState.INSERT;
                this.insertBytes = b;
                this.pos = o;
                this.endPos = this.pos + l;
            })) {
                this.resultPos = DeltaModifiedIBytes.this.theLength;
            }
        }
    }

    @Immutable
    private static final class Mark {
        private final int resultPos;
        private final byte[] insertBytes;
        private final int pos;
        private final int endPos;
        private final DeltaState deltaState;
        private final Object parserMark;
        private final Object valueStreamMark;

        Mark(int resultPos, byte[] insertBytes, int pos, int endPos, DeltaState deltaState, Object parser, Object valueStream) {
            this.resultPos = resultPos;
            this.insertBytes = insertBytes;
            this.pos = pos;
            this.endPos = endPos;
            this.deltaState = deltaState;
            this.parserMark = parser;
            this.valueStreamMark = valueStream;
        }
    }

    private static enum DeltaState {
        MATCH,
        INSERT;

    }
}

