/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaImpl;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParserCompressor;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltas;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import java.util.List;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class CompositeBinaryDelta
implements InternalBinaryDelta {
    private final InternalBinaryDelta earlier;
    private final InternalBinaryDelta later;

    public static InternalBinaryDelta compose(List<? extends InternalBinaryDelta> list) {
        if (list.isEmpty()) {
            return BinaryDeltas.NO_CHANGE;
        }
        return CompositeBinaryDelta.compose(list, 0, list.size());
    }

    private static InternalBinaryDelta compose(List<? extends InternalBinaryDelta> list, int start, int length) {
        if (length == 1) {
            return list.get(start);
        }
        int half = length >> 1;
        InternalBinaryDelta left = CompositeBinaryDelta.compose(list, start, half);
        InternalBinaryDelta right = CompositeBinaryDelta.compose(list, start + half, length - half);
        return CompositeBinaryDelta.compose(left, right);
    }

    public static InternalBinaryDelta compose(InternalBinaryDelta earlier, InternalBinaryDelta later) {
        if (!earlier.hasChanges()) {
            return later;
        }
        if (!later.hasChanges()) {
            return earlier;
        }
        return new CompositeBinaryDelta(earlier, later);
    }

    private CompositeBinaryDelta(InternalBinaryDelta earlier, InternalBinaryDelta later) {
        this.earlier = earlier;
        this.later = later;
    }

    @Override
    public boolean hasChanges() {
        return true;
    }

    @Override
    public int length() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BinaryDeltaImpl toIBytes() {
        return this.compress();
    }

    @Override
    public BinaryDeltaImpl compress() {
        return BinaryDeltaParserCompressor.compress(this.createParser());
    }

    @Override
    public IBytes apply(ArrayIBytes oldValue) {
        IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
        BinaryDeltaParser parser = this.createParser();
        while (parser.next((start, length) -> CompositeBinaryDelta.copyRange(out, oldValue, start, length), out::write)) {
        }
        return ((IBytesOutputStream)out).toIBytes();
    }

    private static void copyRange(IBytesOutputStream out, ArrayIBytes value, int start, int length) {
        try {
            out.write(value.bytes(), value.offset() + start, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidDataException(e);
        }
    }

    @Override
    public BinaryDeltaParser createParser() {
        return new CompositeBinaryDeltaParser();
    }

    @NotThreadSafe
    private final class CompositeBinaryDeltaParser
    extends ParserState
    implements BinaryDeltaParser {
        private BinaryDeltaParser a;
        private final BinaryDeltaParser b;

        private CompositeBinaryDeltaParser() {
            this.b = CompositeBinaryDelta.this.later.createParser();
        }

        private BinaryDeltaParser ensureA() {
            if (this.a == null) {
                this.a = CompositeBinaryDelta.this.earlier.createParser();
            }
            return this.a;
        }

        @Override
        public boolean next(BinaryDeltaParser.MatchConsumer onMatch, BinaryDeltaParser.InsertConsumer onInsert) {
            if (this.bMatchStart < 0 && this.findMatchB(onInsert)) {
                return true;
            }
            if (this.bMatchStart == Integer.MAX_VALUE) {
                return false;
            }
            if (this.aMatchStart >= 0 && this.continueMatchA(onMatch) || this.aInsertBytes != null && this.continueInsertA(onInsert)) {
                return true;
            }
            if (this.ensureA().next((start, length) -> this.beginMatchA(start, length, onMatch), (bytes, o, l) -> this.beginInsertA(bytes, o, l, onInsert))) {
                return true;
            }
            assert (this.bMatchStart >= 0);
            throw new InvalidDataException("Deltas do not compose");
        }

        private void beginMatchA(int start, int length, BinaryDeltaParser.MatchConsumer onMatch) {
            assert (this.aInsertBytes == null);
            this.offset += start - this.aMatchEnd;
            this.aMatchStart = start;
            this.aMatchEnd = start + length;
            this.continueMatchA(onMatch);
        }

        private boolean continueMatchA(BinaryDeltaParser.MatchConsumer onMatch) {
            assert (this.aMatchStart >= 0 && this.bMatchStart >= 0);
            int translatedBMatchStart = this.bMatchStart + this.offset;
            if (translatedBMatchStart >= this.aMatchEnd) {
                this.aMatchStart = -1;
                return false;
            }
            int bMatchLength = this.bMatchEnd - this.bMatchStart;
            if (translatedBMatchStart + bMatchLength <= this.aMatchEnd) {
                onMatch.accept(translatedBMatchStart, bMatchLength);
                this.bMatchStart = -1;
                this.aMatchStart = translatedBMatchStart + bMatchLength;
            } else {
                int splitLength = this.aMatchEnd - translatedBMatchStart;
                onMatch.accept(translatedBMatchStart, splitLength);
                this.bMatchStart += splitLength;
                this.aMatchStart = -1;
            }
            return true;
        }

        private void beginInsertA(byte[] bytes, int bytesOffset, int length, BinaryDeltaParser.InsertConsumer onInsert) {
            assert (this.aMatchStart < 0);
            this.aInsertBytes = bytes;
            this.aInsertOffset = bytesOffset;
            this.aInsertLength = length;
            this.continueInsertA(onInsert);
        }

        private boolean continueInsertA(BinaryDeltaParser.InsertConsumer onInsert) {
            assert (this.aInsertBytes != null && this.bMatchStart >= 0);
            int inserted = this.bMatchStart + this.offset - this.aMatchEnd;
            int remaining = this.aInsertLength - inserted;
            if (remaining <= 0) {
                this.insertAComplete();
                return false;
            }
            int firstByte = this.aInsertOffset + inserted;
            int bMatchLength = this.bMatchEnd - this.bMatchStart;
            if (bMatchLength <= remaining) {
                onInsert.accept(this.aInsertBytes, firstByte, bMatchLength);
                this.bMatchStart = -1;
                if (bMatchLength == remaining) {
                    this.insertAComplete();
                }
            } else {
                onInsert.accept(this.aInsertBytes, firstByte, remaining);
                this.bMatchStart += remaining;
                this.insertAComplete();
            }
            return true;
        }

        private void insertAComplete() {
            this.aInsertBytes = null;
            this.offset -= this.aInsertLength;
        }

        private boolean findMatchB(BinaryDeltaParser.InsertConsumer onInsert) {
            if (!this.b.next(this::onMatch, onInsert)) {
                this.bMatchStart = Integer.MAX_VALUE;
                return false;
            }
            return this.bMatchStart < 0;
        }

        private void onMatch(int start, int length) {
            this.bMatchStart = start;
            this.bMatchEnd = start + length;
        }

        @Override
        public Mark mark() {
            Mark m = new Mark(this.a != null ? this.a.mark() : null, this.b.mark());
            m.copyFrom(this);
            return m;
        }

        @Override
        public void reset(Object o) {
            Mark mark = (Mark)o;
            this.copyFrom(mark);
            if (mark.a != null) {
                this.a.reset(mark.a);
            } else {
                this.a = null;
            }
            this.b.reset(mark.b);
        }
    }

    @Immutable
    private static final class Mark
    extends ParserState {
        private final Object a;
        private final Object b;

        Mark(Object aMark, Object bMark) {
            this.a = aMark;
            this.b = bMark;
        }
    }

    private static class ParserState {
        protected int offset;
        protected int aMatchStart = -1;
        protected int aMatchEnd;
        protected byte[] aInsertBytes;
        protected int aInsertOffset;
        protected int aInsertLength;
        protected int bMatchStart = -1;
        protected int bMatchEnd;

        private ParserState() {
        }

        protected final void copyFrom(ParserState other) {
            this.offset = other.offset;
            this.aMatchStart = other.aMatchStart;
            this.aMatchEnd = other.aMatchEnd;
            this.aInsertBytes = other.aInsertBytes;
            this.aInsertOffset = other.aInsertOffset;
            this.aInsertLength = other.aInsertLength;
            this.bMatchStart = other.bMatchStart;
            this.bMatchEnd = other.bMatchEnd;
        }
    }
}

