/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.BinaryDelta;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DeltaType;
import com.pushtechnology.diffusion.datatype.diff.BinaryDiff;
import com.pushtechnology.diffusion.datatype.diff.MyersBinaryDiff;
import com.pushtechnology.diffusion.datatype.internal.AbstractDataType;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaImpl;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaSerialiser;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltas;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.datatype.internal.SupplierFromBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import net.jcip.annotations.Immutable;

@Immutable
public final class BinaryDeltaType<V, C extends ArrayIBytes>
implements DeltaType<V, BinaryDelta> {
    private final String name;
    private final SupplierFromBytes<? extends C> implementationFactory;
    private final Function<V, C> vToC;
    private final Function<C, V> cToV;

    public BinaryDeltaType(SupplierFromBytes<? extends C> implementationFactory, Function<V, C> vToC, Function<C, V> cToV) {
        this("binary", implementationFactory, vToC, cToV);
    }

    BinaryDeltaType(String name, SupplierFromBytes<? extends C> implementationFactory, Function<V, C> vToC, Function<C, V> cToV) {
        this.name = name;
        this.implementationFactory = implementationFactory;
        this.vToC = vToC;
        this.cToV = cToV;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InternalBinaryDelta diff(V oldValue, V newValue) {
        ArrayIBytes a = (ArrayIBytes)this.vToC.apply(oldValue);
        ArrayIBytes b = (ArrayIBytes)this.vToC.apply(newValue);
        return new DeltaBuilder(this, a, b).build();
    }

    @Override
    public V apply(V oldValue, BinaryDelta delta) {
        if (!delta.hasChanges()) {
            return oldValue;
        }
        InternalBinaryDelta internalDelta = BinaryDeltaType.internalDelta(delta);
        ArrayIBytes internalValue = (ArrayIBytes)this.vToC.apply(oldValue);
        byte[] bytes = internalDelta.apply(internalValue).toByteArrayInternal();
        return this.cToV.apply((ArrayIBytes)this.implementationFactory.get(bytes, 0, bytes.length));
    }

    @Override
    public BinaryDelta noChange() {
        return BinaryDeltas.NO_CHANGE;
    }

    @Override
    public boolean isValueCheaper(V value, BinaryDelta delta) {
        return ((ArrayIBytes)this.vToC.apply(value)).length() <= BinaryDeltaType.internalDelta(delta).length();
    }

    @Override
    public void writeDelta(BinaryDelta delta, OutputStream out) throws IOException {
        this.toBytes(delta).copyTo(out);
    }

    public IBytes toBytes(BinaryDelta delta) {
        return BinaryDeltaType.internalDelta(delta).toIBytes();
    }

    @Override
    public BinaryDeltaImpl readDelta(byte[] in, int offset, int length) {
        return new BinaryDeltaImpl(in, offset, length);
    }

    @Override
    public BinaryDeltaImpl readDelta(byte[] in) {
        return this.readDelta(in, 0, in.length);
    }

    @Override
    public BinaryDeltaImpl readDelta(Bytes bytes) {
        return this.readDelta(IBytes.toByteArray(bytes));
    }

    public static boolean isReplacement(Object delta) {
        return delta instanceof ReplacementBinaryDelta;
    }

    private static InternalBinaryDelta internalDelta(BinaryDelta delta) {
        return (InternalBinaryDelta)delta;
    }

    private static boolean conflatableMatch(int matchStart, int matchLength, int insertLength) {
        int matchCost = AbstractDataType.cborIntegerCost(matchStart) + 1;
        int insertCost = AbstractDataType.cborIntegerCost(matchLength + insertLength) - AbstractDataType.cborIntegerCost(insertLength) + matchLength;
        return insertCost <= matchCost;
    }

    private static final class DeltaBuilder {
        private final C oldValue;
        private final C newValue;
        private final IBytesOutputStream out = AbstractDataType.threadLocalIBytesOutputStream();
        private int spaceBudget;
        final /* synthetic */ BinaryDeltaType this$0;

        DeltaBuilder(C oldValue, C newValue) {
            this.this$0 = var1_1;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.spaceBudget = newValue.length();
        }

        InternalBinaryDelta build() {
            switch (MyersBinaryDiff.threadLocal().diff(this.oldValue.bytes(), this.oldValue.offset(), this.oldValue.length(), this.newValue.bytes(), this.newValue.offset(), this.newValue.length(), new Script())) {
                case REPLACE: {
                    return new ReplacementBinaryDelta((ArrayIBytes)this.newValue);
                }
                case NO_CHANGE: {
                    return BinaryDeltas.NO_CHANGE;
                }
            }
            return this.this$0.readDelta(this.out.toIBytes());
        }

        private boolean blowsBudget(int cost) {
            this.spaceBudget -= cost;
            return this.spaceBudget <= 0;
        }

        private final class Script
        implements BinaryDiff.EditScript {
            private int insertStart = -1;
            private int insertLength;
            private int matchStart = -1;
            private int matchLength;

            private Script() {
            }

            @Override
            public boolean match(int aStart, int length) {
                if (this.matchStart != -1) {
                    assert (this.matchStart + this.matchLength < aStart) : "adjacent matches";
                    if (!this.flush()) {
                        return false;
                    }
                } else if (this.insertStart != -1 && BinaryDeltaType.conflatableMatch(aStart, length, this.insertLength)) {
                    this.insertLength += length;
                    return true;
                }
                this.matchStart = aStart;
                this.matchLength = length;
                return true;
            }

            @Override
            public boolean insert(int bStart, int length) {
                if (this.matchStart != -1) {
                    if (BinaryDeltaType.conflatableMatch(this.matchStart, this.matchLength, length)) {
                        this.matchStart = -1;
                        if (this.insertStart == -1) {
                            this.insertStart = bStart - this.matchLength;
                            this.insertLength = this.matchLength + length;
                        } else {
                            this.insertLength += this.matchLength + length;
                        }
                        return true;
                    }
                    if (!this.flush()) {
                        return false;
                    }
                }
                if (this.insertStart == -1) {
                    this.insertStart = bStart;
                    this.insertLength = length;
                } else {
                    this.insertLength += length;
                }
                return true;
            }

            @Override
            public boolean close() {
                return this.flush();
            }

            private boolean flush() {
                return !(this.insertStart != -1 && !this.writeInsert() || this.matchStart != -1 && !this.writeMatch());
            }

            private boolean writeInsert() {
                if (DeltaBuilder.this.blowsBudget(this.insertLength + AbstractDataType.cborIntegerCost(this.insertLength))) {
                    return false;
                }
                BinaryDeltaSerialiser.writeInsert(DeltaBuilder.this.out, DeltaBuilder.this.newValue.bytes(), DeltaBuilder.this.newValue.offset() + this.insertStart, this.insertLength);
                this.insertStart = -1;
                return true;
            }

            private boolean writeMatch() {
                if (DeltaBuilder.this.blowsBudget(AbstractDataType.cborIntegerCost(this.matchStart) + AbstractDataType.cborIntegerCost(this.matchLength))) {
                    return false;
                }
                BinaryDeltaSerialiser.writeMatch(DeltaBuilder.this.out, this.matchStart, this.matchLength);
                this.matchStart = -1;
                return true;
            }
        }
    }

    @Immutable
    private static final class ReplacementBinaryDelta
    implements InternalBinaryDelta {
        private final ArrayIBytes value;

        ReplacementBinaryDelta(ArrayIBytes value) {
            this.value = value;
        }

        @Override
        public boolean hasChanges() {
            return true;
        }

        @Override
        public int length() {
            int length = this.value.length();
            return AbstractDataType.cborIntegerCost(length) + length;
        }

        @Override
        public BinaryDeltaImpl toIBytes() {
            IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
            BinaryDeltaSerialiser.writeInsert(out, this.value.bytes(), this.value.offset(), this.value.length());
            byte[] serialised = out.toByteArray();
            return new BinaryDeltaImpl(serialised, 0, serialised.length);
        }

        @Override
        public IBytes apply(ArrayIBytes internalValue) {
            return this.value;
        }

        @Override
        public BinaryDeltaParser createParser() {
            return new BinaryDeltaParser(){
                private boolean inserted;

                @Override
                public boolean next(BinaryDeltaParser.MatchConsumer onMatch, BinaryDeltaParser.InsertConsumer onInsert) {
                    if (!this.inserted) {
                        this.inserted = true;
                        onInsert.accept(value.bytes(), value.offset(), value.length());
                        return true;
                    }
                    return false;
                }

                @Override
                public Boolean mark() {
                    return this.inserted;
                }

                @Override
                public void reset(Object mark) {
                    this.inserted = (Boolean)mark;
                }
            };
        }
    }
}

