/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;

public final class BinaryDeltaSerialiser {
    private BinaryDeltaSerialiser() {
    }

    public static void writeMatch(IBytesOutputStream out, int start, int length) {
        BinaryDeltaSerialiser.writeUint(out, 0, start);
        BinaryDeltaSerialiser.writeUint(out, 0, length);
    }

    public static void writeInsert(IBytesOutputStream out, byte[] data, int offset, int length) {
        BinaryDeltaSerialiser.writeInsertLength(out, length);
        out.write(data, offset, length);
    }

    public static void writeInsertLength(IBytesOutputStream out, int length) {
        BinaryDeltaSerialiser.writeUint(out, 64, length);
    }

    public static void writeInsertBytes(IBytesOutputStream out, byte[] data, int offset, int length) {
        out.write(data, offset, length);
    }

    private static void writeUint(IBytesOutputStream out, int majorType, int i) {
        if (i < 24) {
            out.write(majorType + i);
        } else if (i < 256) {
            BinaryDeltaSerialiser.writeUint8(out, majorType, i);
        } else if (i < 65536) {
            BinaryDeltaSerialiser.writeUint16(out, majorType, i);
        } else {
            BinaryDeltaSerialiser.writeUint32(out, majorType, i);
        }
    }

    private static void writeUint8(IBytesOutputStream out, int majorType, int i) {
        out.write(majorType + 24);
        out.write(i);
    }

    private static void writeUint16(IBytesOutputStream out, int majorType, int i) {
        out.write(majorType + 25);
        out.write(i >> 8);
        out.write(i >> 0);
    }

    private static void writeUint32(IBytesOutputStream out, int majorType, int i) {
        out.write(majorType + 26);
        out.write(i >> 24);
        out.write(i >> 16);
        out.write(i >> 8);
        out.write(i >> 0);
    }
}

