/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.PartialArrayIBytes;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class AbstractBytes
extends PartialArrayIBytes {
    protected AbstractBytes(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public String toString() {
        byte[] bytes = this.bytes();
        int offset = this.offset();
        int length = this.length();
        int maxBytes = Math.min(80, length);
        byte[] b = new byte[maxBytes];
        for (int i = 0; i < maxBytes; ++i) {
            b[i] = bytes[offset + i];
        }
        return "Binary <" + this.length() + " bytes> " + CharsetUtils.bytesUTF8ToString(b);
    }

    @Override
    public final boolean equals(Object o) {
        return o == this || this.classIsCompatible(o) && super.equals(o);
    }

    @Override
    public final int compareTo(IBytes o) {
        if (!this.classIsCompatible(o)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return super.compareTo(o);
    }

    private boolean classIsCompatible(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }
}

