/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.conversation;

import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdGenerator;
import com.pushtechnology.diffusion.conversation.ConversationSet;
import com.pushtechnology.diffusion.conversation.NoSuchConversationException;
import com.pushtechnology.diffusion.conversation.ResponseHandler;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ConversationSetImpl
implements ConversationSet {
    private static final Logger LOG = I18nLogger.getLogger(ConversationSetImpl.class);
    private static final AtomicLong NEXT_SET_ID = new AtomicLong(0L);
    private final long conversationSetID;
    private final ConversationIdGenerator idGenerator;
    private final ConcurrentMap<ConversationId, Conversation> byID = new ConcurrentHashMap<ConversationId, Conversation>(16, 0.75f, 1);
    private final AtomicReference<Throwable> setDiscardReason = new AtomicReference();

    ConversationSetImpl(ConversationIdGenerator idGenerator) {
        this.conversationSetID = NEXT_SET_ID.incrementAndGet();
        this.idGenerator = idGenerator;
    }

    @Override
    public ConversationId newConversation(ResponseHandler responseHandler) {
        return this.newConversation(cid -> {}, responseHandler);
    }

    @Override
    public ConversationId newConversation(Consumer<ConversationId> onOpen, ResponseHandler responseHandler) {
        ConversationId id = this.idGenerator.create();
        Conversation ch = new Conversation(responseHandler);
        Conversation old = this.byID.putIfAbsent(id, ch);
        assert (old == null) : old;
        try {
            onOpen.accept(id);
        }
        catch (Throwable t) {
            this.completedExceptionally(id, ch, t);
            throw t;
        }
        Throwable reason = this.setDiscardReason.get();
        if (reason != null) {
            this.discard(id, reason);
        }
        return id;
    }

    private void completedExceptionally(ConversationId id, Conversation c, Throwable t) {
        LOG.debug("CONVERSATION_APPLICATION_HANDLER_EXCEPTION", (Object)id, (Object)t);
        c.setFinished(State.EXCEPTION);
        this.byID.remove(id);
    }

    @Override
    public void respond(ConversationId id, Object response) throws NoSuchConversationException {
        Conversation ch = (Conversation)this.byID.get(id);
        if (ch == null) {
            LOG.debug("No conversation for cid={} response={}", (Object)id, response);
            throw new NoSuchConversationException(id);
        }
        Result r = ch.respond(id, response);
        switch (r) {
            case ALREADY_FINISHED: {
                throw new NoSuchConversationException(id);
            }
            case HANDLED_AND_ACTIVE: {
                break;
            }
            default: {
                this.byID.remove(id);
            }
        }
    }

    @Override
    public void respondIfPresent(ConversationId id, Object response) {
        Conversation ch = (Conversation)this.byID.get(id);
        if (ch == null) {
            LOG.debug("No conversation for cid={} response ={}", (Object)id, response);
            return;
        }
        if (ch.respond(id, response) == Result.HANDLED_AND_FINISHED) {
            this.byID.remove(id);
        }
    }

    @Override
    public void discard(ConversationId id, Throwable reason) {
        Conversation ch = (Conversation)this.byID.remove(id);
        if (ch != null) {
            ch.discard(id, reason);
        }
    }

    @Override
    public void discardAll(Throwable reason) {
        if (!this.setDiscardReason.compareAndSet(null, Objects.requireNonNull(reason))) {
            return;
        }
        for (Map.Entry e : this.byID.entrySet()) {
            Conversation ch = (Conversation)e.getValue();
            if (ch == null) continue;
            ch.discard((ConversationId)e.getKey(), reason);
        }
        this.byID.clear();
    }

    public String toString() {
        return "ConversationSetImpl<" + this.conversationSetID + ">";
    }

    @Override
    public int estimatedSize() {
        return this.byID.size();
    }

    final class Conversation {
        private final ResponseHandler handler;
        @GuardedBy(value="this")
        private State state = State.UNRESERVED;
        @GuardedBy(value="this")
        private Throwable pendingDiscard;

        Conversation(ResponseHandler handler) {
            this.handler = handler;
        }

        synchronized void setFinished(State target) {
            if (!this.state.isFinished()) {
                this.state = target;
            }
        }

        synchronized Result respond(ConversationId id, Object response) {
            boolean close;
            State oldState = this.state;
            if (oldState.isFinished()) {
                return Result.ALREADY_FINISHED;
            }
            this.state = State.RESERVED;
            try {
                close = this.handler.onResponse(id, response);
            }
            catch (Throwable t) {
                ConversationSetImpl.this.completedExceptionally(id, this, t);
                throw t;
            }
            if (this.state.isFinished()) {
                return Result.HANDLED_AND_FINISHED;
            }
            if (close) {
                this.state = State.CLOSED;
                return Result.HANDLED_AND_FINISHED;
            }
            if (oldState == State.UNRESERVED && this.pendingDiscard != null) {
                this.state = State.DISCARDED;
                this.notifyDiscard(id, this.pendingDiscard);
                return Result.HANDLED_AND_FINISHED;
            }
            this.state = State.UNRESERVED;
            return Result.HANDLED_AND_ACTIVE;
        }

        synchronized void discard(ConversationId id, Throwable reason) {
            State oldState = this.state;
            if (oldState == State.RESERVED) {
                this.pendingDiscard = reason;
            } else {
                this.state = State.DISCARDED;
                if (oldState == State.UNRESERVED) {
                    this.notifyDiscard(id, reason);
                }
            }
        }

        public String toString() {
            return String.format("%s[state=%s handler=%s]", new Object[]{this.getClass().getSimpleName(), this.state, this.handler});
        }

        private void notifyDiscard(ConversationId id, Throwable reason) {
            try {
                this.handler.onDiscard(id, reason);
            }
            catch (Exception e) {
                LOG.error("CONVERSATION_APPLICATION_HANDLER_EXCEPTION", (Object)id, (Object)e);
            }
            catch (Throwable t) {
                LOG.error("CONVERSATION_APPLICATION_HANDLER_EXCEPTION", (Object)id, (Object)t);
                throw t;
            }
        }
    }

    static enum State {
        UNRESERVED,
        RESERVED,
        CLOSED,
        DISCARDED,
        EXCEPTION;


        boolean isFinished() {
            return this != UNRESERVED && this != RESERVED;
        }
    }

    static enum Result {
        ALREADY_FINISHED,
        HANDLED_AND_ACTIVE,
        HANDLED_AND_FINISHED;

    }
}

