/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.control.registration;

import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import com.pushtechnology.diffusion.control.ControlGroup;
import com.pushtechnology.diffusion.control.registration.ControlRegistrationParameters;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class MessageReceiverControlRegistrationParameters
extends ControlRegistrationParameters {
    private final String theTopicPath;
    private final List<String> thePropertyKeys;

    public MessageReceiverControlRegistrationParameters(ServiceDefinition<?, ?> definition, ControlGroup group, String topicPath, List<String> propertyKeys) {
        this(definition.getID(), group, topicPath, propertyKeys);
    }

    MessageReceiverControlRegistrationParameters(int serviceId, ControlGroup group, String topicPath, List<String> propertyKeys) {
        super(serviceId, group);
        this.theTopicPath = topicPath;
        this.thePropertyKeys = propertyKeys;
    }

    public String getTopicPath() {
        return this.theTopicPath;
    }

    public List<String> getPropertyKeys() {
        return Collections.unmodifiableList(this.thePropertyKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.theTopicPath, this.thePropertyKeys);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        MessageReceiverControlRegistrationParameters other = (MessageReceiverControlRegistrationParameters)o;
        return this.theTopicPath.equals(other.theTopicPath) && this.thePropertyKeys.equals(other.thePropertyKeys);
    }

    @Override
    public String toStringDetails() {
        return super.toStringDetails() + ", " + this.theTopicPath + ", " + String.valueOf(this.thePropertyKeys);
    }

    @Override
    public Map<String, Object> getJournableContext() {
        Map<String, Object> context = super.getJournableContext();
        context.put("path", this.theTopicPath);
        context.put("properties", this.thePropertyKeys);
        return context;
    }
}

