/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.control.registration;

import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import com.pushtechnology.diffusion.control.ControlGroup;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class ControlRegistrationParameters
implements Journable {
    private final int serviceId;
    private final ControlGroup group;

    public ControlRegistrationParameters(ServiceDefinition<?, ?> definition, ControlGroup group) {
        this(definition.getID(), group);
    }

    ControlRegistrationParameters(int serviceId, ControlGroup group) {
        this.serviceId = serviceId;
        this.group = group;
    }

    public final int getServiceId() {
        return this.serviceId;
    }

    public final ControlGroup getControlGroup() {
        return this.group;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.serviceId;
        result = 31 * result + this.group.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControlRegistrationParameters other = (ControlRegistrationParameters)o;
        return this.serviceId == other.serviceId && this.group.equals(other.group);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.toStringDetails() + ")";
    }

    protected String toStringDetails() {
        return this.serviceId + ", " + String.valueOf(this.group);
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(3);
        context.put("group", this.group.getName());
        context.put("service", this.serviceId);
        return context;
    }
}

