/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.control.registration;

import com.pushtechnology.diffusion.control.registration.ControlRegistrationParameters;
import com.pushtechnology.diffusion.control.registration.ControlRegistrationRequest;
import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdSerialiser;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
abstract class AbstractControlRegistrationRequestSerialiser<T extends ControlRegistrationRequest<K>, K extends ControlRegistrationParameters>
extends AbstractSerialiser<T> {
    private final Serialiser<K> keySerialiser;
    private final ConversationIdSerialiser conversationIDSerialiser;

    AbstractControlRegistrationRequestSerialiser(Serialiser<K> keySerialiser, ConversationIdSerialiser conversationIDSerialiser) {
        this.keySerialiser = keySerialiser;
        this.conversationIDSerialiser = conversationIDSerialiser;
    }

    @Override
    public void write(OutputStream out, T value) throws IOException {
        this.keySerialiser.write(out, value.getParameters());
        this.conversationIDSerialiser.write(out, value.getConversationID());
    }

    @Override
    public final T readUnchecked(InputStream in) throws IOException {
        ControlRegistrationParameters key = (ControlRegistrationParameters)this.keySerialiser.read(in);
        ConversationId cid = (ConversationId)this.conversationIDSerialiser.read(in);
        return this.completeRead(in, key, cid);
    }

    protected abstract T completeRead(InputStream var1, K var2, ConversationId var3) throws IOException;
}

