/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.content.encoding;

import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class ZlibCompression {
    private static final FastThreadLocal<ZlibCompression> THREAD_LOCAL = FastThreadLocal.withInitial(ZlibCompression::new);
    private static final byte[] EMPTY = new byte[0];
    private final Deflater deflater = new Deflater();
    private final Inflater inflater = new Inflater();
    private byte[] temporaryBuffer;
    private final IBytesOutputStream bytes = new IBytesOutputStreamImpl();
    private CompressedIBytesOutputStream stream = null;
    private final int maximumUncompressed;

    public static ZlibCompression forThread() {
        return THREAD_LOCAL.get();
    }

    public ZlibCompression() {
        this(ConfigurationUtils.getIntegerSystemProperty("diffusion.zlib.initial_temporary_buffer_size", 65536), ConfigurationUtils.getIntegerSystemProperty("diffusion.zlib.maximum_uncompressed_buffer_size", 0x100000));
    }

    ZlibCompression(int temporaryBufferLength, int maximumUncompressed) {
        this.maximumUncompressed = maximumUncompressed;
        this.temporaryBuffer = new byte[temporaryBufferLength];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBytesOutputStream compress(int compressionLevel, byte[] input, int offset, int length) {
        try {
            this.resetForCompress(compressionLevel);
            this.compressSome(input, offset, length);
            this.finishCompress();
            IBytesOutputStream iBytesOutputStream = this.bytes;
            return iBytesOutputStream;
        }
        finally {
            this.deflater.setInput(EMPTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBytesOutputStream decompress(byte[] input, int offset, int length) throws DataFormatException {
        this.bytes.reset();
        try {
            this.inflater.setInput(input, offset, length);
            while (!this.inflater.finished()) {
                int count = this.inflater.inflate(this.temporaryBuffer);
                if (count == 0) {
                    throw new DataFormatException("Failed to decompress message");
                }
                this.bytes.write(this.temporaryBuffer, 0, count);
            }
            IBytesOutputStream iBytesOutputStream = this.bytes;
            return iBytesOutputStream;
        }
        finally {
            this.inflater.reset();
        }
    }

    public IBytesOutputStream resetIBytesOutputStream(int compressionLevel) {
        if (this.stream == null) {
            this.stream = new CompressedIBytesOutputStream();
        }
        this.stream.reset(compressionLevel);
        return this.stream;
    }

    private void resetForCompress(int compressionLevel) {
        this.deflater.reset();
        this.bytes.reset();
        this.deflater.setLevel(compressionLevel);
    }

    private void compressSome(byte[] input, int offset, int length) {
        if (this.deflater.finished()) {
            throw new IllegalStateException("Deflater finished");
        }
        this.deflater.setInput(input, offset, length);
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    private void finishCompress() {
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate();
        }
    }

    private void deflate() {
        int count = this.deflater.deflate(this.temporaryBuffer);
        this.bytes.write(this.temporaryBuffer, 0, count);
    }

    @NotThreadSafe
    private final class CompressedIBytesOutputStream
    extends IBytesOutputStream {
        private int compressionLevel;
        private byte[] uncompressed = new byte[32];
        private int used;

        private CompressedIBytesOutputStream() {
        }

        void reset(int level) {
            this.compressionLevel = level;
            this.reset();
        }

        @Override
        public void reset() {
            this.used = 0;
            ZlibCompression.this.resetForCompress(this.compressionLevel);
        }

        @Override
        public void write(int b) {
            this.maybeGrowUncompressed(1);
            this.uncompressed[this.used] = (byte)b;
            ++this.used;
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.maybeGrowUncompressed(len);
            System.arraycopy(b, off, this.uncompressed, this.used, len);
            this.used += len;
        }

        private void maybeGrowUncompressed(int required) {
            int l = this.uncompressed.length;
            if (l - this.used < required) {
                int newLength = Math.max(this.used + required, l << 1);
                if (newLength > ZlibCompression.this.maximumUncompressed) {
                    this.deflateUncompressed();
                    if (l < required) {
                        this.uncompressed = new byte[required];
                    }
                } else {
                    this.uncompressed = Arrays.copyOf(this.uncompressed, newLength);
                }
            }
        }

        @Override
        public void close() {
            this.deflateUncompressed();
            ZlibCompression.this.finishCompress();
        }

        private void deflateUncompressed() {
            ZlibCompression.this.compressSome(this.uncompressed, 0, this.used);
            this.used = 0;
        }

        @Override
        public void flush() {
            this.deflateUncompressed();
            while (true) {
                int len = ZlibCompression.this.deflater.deflate(ZlibCompression.this.temporaryBuffer, 0, ZlibCompression.this.temporaryBuffer.length, 2);
                ZlibCompression.this.bytes.write(ZlibCompression.this.temporaryBuffer, 0, len);
                if (len == 0) break;
                if (len != ZlibCompression.this.temporaryBuffer.length) continue;
                ZlibCompression.this.temporaryBuffer = new byte[ZlibCompression.this.temporaryBuffer.length << 1];
            }
        }

        @Override
        public int length() {
            return ZlibCompression.this.bytes.length();
        }

        @Override
        public IBytes toIBytes() {
            this.checkFinished();
            return ZlibCompression.this.bytes.toIBytes();
        }

        @Override
        public String fromUTF8() {
            throw new UnsupportedOperationException("Compressed data isn't UTF8");
        }

        @Override
        public void copyTo(OutputStream out) throws IOException {
            this.checkFinished();
            ZlibCompression.this.bytes.copyTo(out);
        }

        @Override
        public void copyTo(ByteBuffer buffer) {
            this.checkFinished();
            ZlibCompression.this.bytes.copyTo(buffer);
        }

        private void checkFinished() {
            if (!ZlibCompression.this.deflater.finished()) {
                throw new IllegalStateException("Call close before accessing bytes.");
            }
        }
    }
}

