/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.constraints;

import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.constraints.AbstractPartialJSONSerialiser;
import com.pushtechnology.diffusion.constraints.ConstraintValueType;
import com.pushtechnology.diffusion.constraints.PartialJSONImpl;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.json.impl.JSONPointer;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
final class PartialJSONSerialiser
extends AbstractPartialJSONSerialiser {
    PartialJSONSerialiser(DataTypes dataTypes) {
        super(dataTypes);
    }

    @Override
    protected UpdateConstraint.PartialJSON readUnchecked(InputStream in) throws IOException {
        Map<JSONPointer, Bytes> withValues = PartialJSONSerialiser.readMap(in, AbstractPartialJSONSerialiser::readJSONPointer, i -> ArrayIBytes.toArrayIBytes(EncodedDataCodec.readByteArray(i)));
        Set withoutValues = PartialJSONSerialiser.readCollection(in, HashSet::new, AbstractPartialJSONSerialiser::readJSONPointer);
        HashMap<JSONPointer, PartialJSONImpl.JSONCondition> convertedWithValues = new HashMap<JSONPointer, PartialJSONImpl.JSONCondition>(withValues.size());
        for (Map.Entry<JSONPointer, Bytes> entry : withValues.entrySet()) {
            convertedWithValues.put(entry.getKey(), new PartialJSONImpl.JSONCondition(UpdateConstraint.Operator.IS, ConstraintValueType.BINARY, entry.getValue()));
        }
        return new PartialJSONImpl(this.dataTypes(), convertedWithValues, withoutValues);
    }

    @Override
    public void write(OutputStream out, UpdateConstraint.PartialJSON value) throws IOException {
        PartialJSONImpl valueImpl = (PartialJSONImpl)value;
        Map<JSONPointer, PartialJSONImpl.JSONCondition> conditionMap = valueImpl.getWithValues();
        HashMap<JSONPointer, Bytes> mapToWrite = new HashMap<JSONPointer, Bytes>(conditionMap.size());
        for (Map.Entry<JSONPointer, PartialJSONImpl.JSONCondition> entry : conditionMap.entrySet()) {
            mapToWrite.put(entry.getKey(), entry.getValue().getBytes());
        }
        PartialJSONSerialiser.writeMap(out, AbstractPartialJSONSerialiser::writeJSONPointer, (o, v) -> EncodedDataCodec.writeByteArray(out, IBytes.toByteArray(v)), mapToWrite);
        PartialJSONSerialiser.writeCollection(out, AbstractPartialJSONSerialiser::writeJSONPointer, valueImpl.getWithoutValues());
    }
}

