/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.constraints;

import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.constraints.CompoundConstraint;
import com.pushtechnology.diffusion.constraints.Constraint;
import com.pushtechnology.diffusion.constraints.ConstraintFactory;
import com.pushtechnology.diffusion.constraints.ConstraintValueType;
import com.pushtechnology.diffusion.constraints.NoValueConstraint;
import com.pushtechnology.diffusion.constraints.TopicConstraint;
import com.pushtechnology.diffusion.constraints.TopicValueConstraint;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.json.impl.JSONPointer;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class PartialJSONImpl
extends TopicConstraint
implements UpdateConstraint.PartialJSON {
    static final Bytes CBOR_NULL = ArrayIBytes.toArrayIBytes(new byte[]{-10});
    static final Bytes CBOR_TRUE = ArrayIBytes.toArrayIBytes(new byte[]{-11});
    static final Bytes CBOR_FALSE = ArrayIBytes.toArrayIBytes(new byte[]{-12});
    private final DataTypes dataTypes;
    private final Map<JSONPointer, JSONCondition> withValues;
    private final Set<JSONPointer> withoutValues;

    public PartialJSONImpl(DataTypes dataTypes) {
        this(dataTypes, new HashMap<JSONPointer, JSONCondition>(), new HashSet<JSONPointer>());
    }

    public PartialJSONImpl(DataTypes dataTypes, Map<JSONPointer, JSONCondition> withValues, Set<JSONPointer> withoutValues) {
        super((byte)6);
        this.dataTypes = dataTypes;
        this.withValues = withValues;
        this.withoutValues = withoutValues;
    }

    @Override
    boolean andBlockedFor(Constraint other) {
        return other instanceof NoValueConstraint || other instanceof TopicValueConstraint || other instanceof CompoundConstraint && other.andBlockedFor(this);
    }

    public Map<JSONPointer, JSONCondition> getWithValues() {
        return Collections.unmodifiableMap(this.withValues);
    }

    public Set<JSONPointer> getWithoutValues() {
        return Collections.unmodifiableSet(this.withoutValues);
    }

    @Override
    public <V> PartialJSONImpl with(String pointerString, Class<V> valueClass, V value) {
        return this.with(pointerString, UpdateConstraint.Operator.IS, value);
    }

    @Override
    public PartialJSONImpl with(String pointerString, UpdateConstraint.Operator operator, Object suppliedValue) {
        ConstraintValueType valueType;
        Bytes valueBytes;
        JSONPointer pointer = JSONPointer.parse(Objects.requireNonNull(pointerString, "pointer is null"));
        Objects.requireNonNull(operator, "operator is null");
        if (suppliedValue == null) {
            if (!ConstraintFactory.isEqualityOperator(operator)) {
                throw new IllegalArgumentException("Invalid operator for null value");
            }
            valueBytes = CBOR_NULL;
            valueType = ConstraintValueType.NULL;
        } else {
            Class<Object> valueClass;
            Object value;
            Class<?> suppliedClass = PartialJSONImpl.validateValue(operator, suppliedValue);
            if (suppliedClass == Integer.class) {
                value = ((Integer)suppliedValue).longValue();
                valueClass = Long.class;
            } else {
                value = suppliedValue;
                valueClass = suppliedClass;
            }
            if (valueClass == Bytes.class) {
                valueType = ConstraintValueType.BINARY;
                valueBytes = (Bytes)value;
            } else if (valueClass == Boolean.class) {
                valueType = ConstraintValueType.BOOLEAN;
                valueBytes = (Boolean)value != false ? CBOR_TRUE : CBOR_FALSE;
            } else {
                DataType<?> dataType = this.dataTypes.getByClass(valueClass);
                valueBytes = dataType.toBytes(value);
                valueType = ConstraintValueType.fromDataType(dataType);
            }
        }
        HashMap<JSONPointer, JSONCondition> newWithValues = new HashMap<JSONPointer, JSONCondition>(this.withValues);
        newWithValues.put(pointer, new JSONCondition(operator, operator == UpdateConstraint.Operator.IS ? ConstraintValueType.BINARY : valueType, valueBytes));
        HashSet<JSONPointer> newWithoutValues = new HashSet<JSONPointer>(this.withoutValues);
        newWithoutValues.remove(pointer);
        return new PartialJSONImpl(this.dataTypes, newWithValues, newWithoutValues);
    }

    private static Class<?> validateValue(UpdateConstraint.Operator operator, Object value) {
        if (operator == UpdateConstraint.Operator.IS && value instanceof Bytes) {
            return Bytes.class;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            if (operator != UpdateConstraint.Operator.EQ) {
                throw new IllegalArgumentException("Invalid operator for Boolean value");
            }
        } else if (valueClass == String.class) {
            if (!ConstraintFactory.isEqualityOperator(operator)) {
                throw new IllegalArgumentException("Invalid operator for String value");
            }
        } else if (valueClass != Long.class && valueClass != Double.class && valueClass != Integer.class) {
            throw new IllegalArgumentException("value type " + valueClass.getSimpleName() + " is not supported with the " + String.valueOf((Object)operator) + " operator");
        }
        return valueClass;
    }

    @Override
    public PartialJSONImpl without(String pointer) {
        JSONPointer parsed = JSONPointer.parse(Objects.requireNonNull(pointer, "pointer is null"));
        HashMap<JSONPointer, JSONCondition> newWithValues = new HashMap<JSONPointer, JSONCondition>(this.withValues);
        newWithValues.remove(parsed);
        HashSet<JSONPointer> newWithoutValues = new HashSet<JSONPointer>(this.withoutValues);
        newWithoutValues.add(parsed);
        return new PartialJSONImpl(this.dataTypes, newWithValues, newWithoutValues);
    }

    public String toString() {
        return "PartialJSON[with=" + String.valueOf(this.withValues) + ", without=" + String.valueOf(this.withoutValues) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialJSONImpl that = (PartialJSONImpl)o;
        return this.withValues.equals(that.withValues) && this.withoutValues.equals(that.withoutValues);
    }

    public int hashCode() {
        return Objects.hash(this.withValues, this.withoutValues);
    }

    public static final class JSONCondition {
        private final UpdateConstraint.Operator theOperator;
        private final ConstraintValueType theValueType;
        private final Bytes theBytes;

        public JSONCondition(UpdateConstraint.Operator operator, ConstraintValueType valueType, Bytes bytes) {
            this.theOperator = operator;
            this.theValueType = valueType;
            this.theBytes = bytes;
        }

        public UpdateConstraint.Operator getOperator() {
            return this.theOperator;
        }

        public ConstraintValueType getValueType() {
            return this.theValueType;
        }

        public Bytes getBytes() {
            return this.theBytes;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.theOperator, this.theValueType, this.theBytes});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JSONCondition)) {
                return false;
            }
            JSONCondition other = (JSONCondition)obj;
            return this.theOperator == other.theOperator && this.theValueType == other.theValueType && Objects.equals(this.theBytes, other.theBytes);
        }

        public String toString() {
            return String.valueOf((Object)this.theOperator) + " " + String.valueOf((Object)this.theValueType) + " " + String.valueOf(this.theBytes);
        }
    }
}

