/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.connection.activity.monitor;

import com.pushtechnology.diffusion.comms.connection.OutboundConnection;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitor;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitorFactory;
import com.pushtechnology.diffusion.connection.activity.monitor.SessionActivityMonitor;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SessionActivityMonitorImpl
implements SessionActivityMonitor {
    private final ConnectionActivityMonitorFactory connectionActivityMonitorFactory;
    private volatile ConnectionActivityMonitor currentConnectionMonitor;

    public SessionActivityMonitorImpl(ConnectionActivityMonitorFactory connectionActivityMonitorFactory) {
        this.connectionActivityMonitorFactory = connectionActivityMonitorFactory;
    }

    @Override
    public void onNewConnection(OutboundConnection connection) {
        ConnectionResponse response = connection.getResponse();
        if (response.getSystemPingPeriod() > 0L) {
            this.currentConnectionMonitor = this.connectionActivityMonitorFactory.create(connection);
        }
    }

    @Override
    public void onConnectionClosed() {
        ConnectionActivityMonitor connectionMonitor = this.currentConnectionMonitor;
        if (connectionMonitor != null) {
            connectionMonitor.shutdown();
            this.currentConnectionMonitor = null;
        }
    }

    @Override
    public void onSystemPing() {
        ConnectionActivityMonitor connectionMonitor = this.currentConnectionMonitor;
        if (connectionMonitor != null) {
            connectionMonitor.onSystemPing();
        }
    }
}

