/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.websocket;

import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.comms.websocket.WebSocketFrameCodec;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.nio.MultiplexerExecutor;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.ReadControlSource;
import com.pushtechnology.diffusion.message.AbortNotificationMessage;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageChannelClosedReason;
import com.pushtechnology.diffusion.message.MessageChannelFeeder;
import com.pushtechnology.diffusion.message.MessageChannelListener;
import com.pushtechnology.diffusion.message.MessageLogger;
import com.pushtechnology.diffusion.messagechannel.MessageChannelMultiplexerClient;
import com.pushtechnology.diffusion.messagechannel.ReadChannelHandlerMessageChannel;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class WebSocketMessageChannel
extends ReadChannelHandlerMessageChannel {
    private final WebSocketFrameCodec messageCodec;

    public WebSocketMessageChannel(NetworkChannel channel, ConnectionInfo connectionInfo, WebSocketFrameCodec messageDeserialiser, int outputBufferSize, MessageChannelMultiplexerClient multiplexerClient, MessageChannelListener listener) {
        super(channel, connectionInfo, outputBufferSize, multiplexerClient, listener);
        this.messageCodec = messageDeserialiser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InboundThreadOnly
    public ReadControlSource.ReadControl handleInput(ByteBuffer buffer) throws IOException {
        int start;
        int lastComplete = start = buffer.position();
        int messageCount = 0;
        int billedMessageCount = 0;
        MessageChannelListener listener = this.getListener();
        try {
            while (buffer.hasRemaining()) {
                Object deserialised = this.messageCodec.readFrame(buffer, this::onCloseFrame);
                ByteBufferDeserialiser.DeserialisationResult result = ByteBufferDeserialiser.DeserialisationResult.decode(deserialised);
                if (result == ByteBufferDeserialiser.DeserialisationResult.INSUFFICIENT_DATA) {
                    ReadControlSource.ReadControl readControl = ReadControlSource.READ_CONTROL.partial();
                    return readControl;
                }
                if (result != ByteBufferDeserialiser.DeserialisationResult.DISCARDED) {
                    Message message = (Message)ByteBufferDeserialiser.DeserialisationResult.deserialisedValue(deserialised);
                    this.getListener().messageReceived(message);
                    ++messageCount;
                    billedMessageCount += message.billedCost();
                }
                lastComplete = buffer.position();
            }
        }
        finally {
            this.logReceived(listener, messageCount, billedMessageCount, lastComplete - start, buffer);
        }
        return ReadControlSource.READ_CONTROL.complete();
    }

    private Object onCloseFrame(int ignored) {
        this.close(MessageChannelClosedReason.REMOTE_CLOSE_REQUESTED, null);
        return ByteBufferDeserialiser.DeserialisationResult.DISCARDED;
    }

    @Override
    @MultiplexerOnly
    protected void doSendMessages(MultiplexerState state, Message firstMessage, MessageChannelFeeder feeder, long now, MultiplexerExecutor partialWriteExecutor) {
        MessageChannelListener.SendResult resultType;
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        int firstMessageSize = firstMessage.size(connectionInfo) + 1;
        ByteBuffer outputBuffer = this.getChannel().bufferForWriting(state.getDirectByteBufferPool(), Math.max(this.getOutputBufferSize(), this.messageCodec.wsFrameLength(firstMessageSize)));
        this.messageCodec.writeFrame(connectionInfo, firstMessage, firstMessageSize, outputBuffer);
        MessageLogger.appendMessage(firstMessage);
        int messageCount = 1;
        int billedMessageCount = firstMessage.billedCost();
        if (firstMessage == AbortNotificationMessage.INSTANCE) {
            resultType = MessageChannelListener.SendResult.ABORT;
        } else {
            while (true) {
                Message message;
                if ((message = feeder.peekMessage()) == null) {
                    resultType = MessageChannelListener.SendResult.QUEUE_DRAINED;
                    break;
                }
                int messageSize = message.size(connectionInfo) + 1;
                if (this.messageCodec.wsFrameLength(messageSize) > outputBuffer.remaining()) {
                    resultType = MessageChannelListener.SendResult.MESSAGES_PENDING;
                    break;
                }
                WebSocketMessageChannel.removePolled(feeder, message);
                this.messageCodec.writeFrame(connectionInfo, message, messageSize, outputBuffer);
                MessageLogger.appendMessage(message);
                ++messageCount;
                billedMessageCount += message.billedCost();
            }
        }
        outputBuffer.flip();
        MessageLogger.logMessages(feeder, messageCount);
        this.writeBuffer(state, outputBuffer, feeder, resultType, messageCount, billedMessageCount, now, partialWriteExecutor);
    }
}

