/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.http;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.api.internal.connection.OutboundHandshakeFactory;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.comms.connection.AbstractHTTPOutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.request.ConnectOrReconnectRequest;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.Protocol4CredentialsTunnel;
import com.pushtechnology.diffusion.comms.connection.request.ReconnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReverseConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponseDeserialiser;
import com.pushtechnology.diffusion.http.HTTPConstants;
import com.pushtechnology.diffusion.http.URIEncoder;
import com.pushtechnology.diffusion.io.ByteSink;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.diffusion.utils.FastEncoder;
import com.pushtechnology.diffusion.utils.PropertyUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public final class PollingClientOutboundHandshake
extends AbstractHTTPOutboundHandshake {
    private static final byte[] ACCEPT_ENCODING_CRLF_BYTES = CharsetUtils.stringToASCII("Accept-Encoding: deflate\r\n");
    static final byte[] POST_BYTES = CharsetUtils.stringToASCII("POST ");
    static final byte COLON = 58;
    public static final OutboundHandshakeFactory FACTORY = (serverDetails, maximumMessageSize, backgroundThreadPool) -> new PollingClientOutboundHandshake(serverDetails, backgroundThreadPool);
    private static final RequestFormatter<ConnectionRequest> CONNECTION_FORMATTER = new ConnectionFormatter();
    private static final RequestFormatter<ReconnectionRequest> RECONNECTION_FORMATTER = new ReconnectionFormatter();
    private static final ByteBufferDeserialiser RESPONSE_DESERIALISER = new ConnectionResponseDeserialiser();

    public PollingClientOutboundHandshake(ServerDetails serverDetails, ScheduledExecutorService backgroundThreadPool) {
        super(serverDetails, backgroundThreadPool);
    }

    @Override
    protected void sendConnectRequest(ByteSink channel, ConnectionRequest request) throws IOException {
        assert (request.getConnectionType() == InternalConnectionType.WEBSOCKET_JAVA_CLIENT || request.getConnectionType() == InternalConnectionType.HTTP_JAVA_CLIENT || request.getConnectionType() == InternalConnectionType.WEBSOCKET_ANDROID_CLIENT || request.getConnectionType() == InternalConnectionType.HTTP_ANDROID_CLIENT || request.getConnectionType().isRemoteServer()) : "Must be a Java client";
        this.sendRequest(channel, CONNECTION_FORMATTER, request);
    }

    @Override
    protected void sendReconnectRequest(ByteSink channel, ReconnectionRequest request) throws IOException {
        assert (request.getConnectionType() == InternalConnectionType.WEBSOCKET_JAVA_CLIENT || request.getConnectionType() == InternalConnectionType.HTTP_JAVA_CLIENT || request.getConnectionType() == InternalConnectionType.WEBSOCKET_ANDROID_CLIENT || request.getConnectionType() == InternalConnectionType.HTTP_ANDROID_CLIENT || request.getConnectionType().isRemoteServer()) : "Must be a Java client";
        this.sendRequest(channel, RECONNECTION_FORMATTER, request);
    }

    @Override
    protected void sendReverseConnectRequest(ByteSink channel, ReverseConnectionRequest request) throws IOException {
        throw new UnsupportedOperationException("Reverse connect not supported for HTTP polling");
    }

    private <T extends ConnectOrReconnectRequest> void sendRequest(ByteSink channel, RequestFormatter<T> requestFormatter, T request) throws IOException {
        IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
        ServerDetails serverDetails = this.getServerDetails();
        PollingClientOutboundHandshake.encodeRequestLine(out, serverDetails.getPath());
        PollingClientOutboundHandshake.encodeHost(out, serverDetails);
        PollingClientOutboundHandshake.encodeHeader((OutputStream)out, HTTPConstants.METHOD_HEADER_BYTES, "0");
        PollingClientOutboundHandshake.encodeHeader((OutputStream)out, HTTPConstants.TYPE_HEADER_BYTES, PollingClientOutboundHandshake.downgradeProtocol(request.getConnectionType()).getHeaderValue());
        ((IBytesOutputStream)out).write(ACCEPT_ENCODING_CRLF_BYTES);
        requestFormatter.addToHeaders(out, request);
        PollingClientOutboundHandshake.encodeHeader((OutputStream)out, HTTPConstants.CONNECTION_BYTES, "keep-alive");
        ((IBytesOutputStream)out).write(HTTPConstants.CRLF);
        ByteBuffer bb = ByteBuffer.allocate(((IBytesOutputStream)out).length());
        ((IBytesOutputStream)out).copyTo(bb);
        bb.flip();
        channel.write(bb, this.getServerDetails().getWriteTimeout());
    }

    private static InternalConnectionType downgradeProtocol(InternalConnectionType original) {
        switch (original) {
            case WEBSOCKET_JAVA_CLIENT: {
                return InternalConnectionType.HTTP_JAVA_CLIENT;
            }
            case WEBSOCKET_FANOUT_CLIENT: {
                return InternalConnectionType.HTTP_FANOUT_CLIENT;
            }
            case WEBSOCKET_SERVER_CLIENT: {
                return InternalConnectionType.HTTP_SERVER_CLIENT;
            }
            case WEBSOCKET_ANDROID_CLIENT: {
                return InternalConnectionType.HTTP_ANDROID_CLIENT;
            }
        }
        return original;
    }

    @Override
    protected ConnectionResponse processResponse(NetworkChannel channel, ByteBuffer initialBuffer) throws IOException {
        this.readHttpHeaders(channel, initialBuffer);
        return this.readConnectionResponse(channel, initialBuffer, RESPONSE_DESERIALISER);
    }

    private static void encodeRequestLine(OutputStream out, String path) throws IOException {
        out.write(POST_BYTES);
        URIEncoder.percentEncodePath(path, out);
        out.write(HTTPConstants.HTTP_VERSION_CRLF_BYTES);
    }

    private static void encodeHost(OutputStream out, ServerDetails serverDetails) throws IOException {
        out.write(HTTPConstants.HOST_BYTES);
        URIEncoder.percentEncode(serverDetails.getHost(), out);
        out.write(58);
        FastEncoder.asciiEncode(Integer.toString(serverDetails.getPort()), out);
        out.write(HTTPConstants.CRLF);
    }

    private static interface RequestFormatter<T> {
        public void addToHeaders(OutputStream var1, T var2) throws IOException;
    }

    private static final class ConnectionFormatter
    implements RequestFormatter<ConnectionRequest> {
        private ConnectionFormatter() {
        }

        @Override
        public void addToHeaders(OutputStream out, ConnectionRequest request) throws IOException {
            Map<String, String> sessionProperties;
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.VERSION_HEADER_BYTES, request.getProtocolVersion().asByte());
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.CAPABILITIES_HEADER_BYTES, request.getCapabilities().asByte());
            PollingClientOutboundHandshake.percentEncodeHeader(out, HTTPConstants.PRINCIPAL_HEADER_BYTES, request.getPrincipal());
            if (request.getCredentials().getType() != Credentials.Type.NONE) {
                PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.PASSWORD_HEADER_BYTES, Protocol4CredentialsTunnel.INSTANCE.encodeAsString(request.getCredentials()));
            }
            if (!(sessionProperties = request.getProposedSessionProperties()).isEmpty()) {
                PollingClientOutboundHandshake.percentEncodeHeader(out, HTTPConstants.SESSION_PROPERTIES_HEADER_BYTES, PropertyUtils.mapToString(sessionProperties));
            }
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.RECONNECT_TIMEOUT_HEADER_BYTES, request.getReconnectionTimeout());
            String serverUUID = request.getServerUUID();
            if (serverUUID != null) {
                PollingClientOutboundHandshake.percentEncodeHeader(out, HTTPConstants.SERVER_UUID_HEADER_BYTES, serverUUID);
            }
        }
    }

    private static final class ReconnectionFormatter
    implements RequestFormatter<ReconnectionRequest> {
        private ReconnectionFormatter() {
        }

        @Override
        public void addToHeaders(OutputStream out, ReconnectionRequest request) throws IOException {
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.VERSION_HEADER_BYTES, request.getProtocolVersion().asByte());
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.CAPABILITIES_HEADER_BYTES, request.getCapabilities().asByte());
            PollingClientOutboundHandshake.encodeSessionToken(out, request.getToken());
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.AVAILABLE_CLIENT_SEQUENCE_HEADER_BYTES, request.availableClientSequence());
            PollingClientOutboundHandshake.encodeHeader(out, HTTPConstants.LAST_SERVER_SEQUENCE_HEADER_BYTES, request.lastServerSequence());
        }
    }
}

