/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.http;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactory;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;

final class NetworkChannelCreator
implements Runnable {
    private static final Logger LOG = I18nLogger.getLogger(NetworkChannelCreator.class);
    private final NetworkChannelFactory networkChannelFactory;
    private final ServerDetails serverDetails;
    private final NetworkContext networkContext;
    private final CompletableFuture<NetworkChannel> completionAction;

    NetworkChannelCreator(NetworkChannelFactory networkChannelFactory, ServerDetails serverDetails, NetworkContext networkContext, CompletableFuture<NetworkChannel> completionAction) {
        this.networkChannelFactory = networkChannelFactory;
        this.serverDetails = serverDetails;
        this.networkContext = networkContext;
        this.completionAction = completionAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DirectByteBufferPool buffers = this.networkContext.getBufferPool();
        try {
            NetworkChannel networkChannel;
            ByteBuffer initialBuffer = buffers.provide(this.serverDetails.getInputBufferSize());
            try {
                networkChannel = this.networkChannelFactory.createChannel(this.serverDetails, initialBuffer, this.networkContext);
            }
            finally {
                buffers.release(initialBuffer);
            }
            this.completionAction.complete(networkChannel);
        }
        catch (ConnectionException e) {
            LOG.debug("Can't create a new network channel", e);
            this.completionAction.completeExceptionally(e);
        }
    }
}

