/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.http;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class CloseLatch {
    private static final AtomicReferenceFieldUpdater<CloseLatch, ClosedState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CloseLatch.class, ClosedState.class, "state");
    private volatile ClosedState state = ClosedState.CLOSED;

    public boolean tryCloseInbound() {
        ClosedState current = this.state;
        ClosedState next = current.closeInbound();
        if (STATE_UPDATER.compareAndSet(this, current, next)) {
            return current != ClosedState.CLOSED && next == ClosedState.CLOSED;
        }
        return false;
    }

    public boolean tryCloseOutbound() {
        ClosedState current = this.state;
        ClosedState next = current.closeOutbound();
        if (STATE_UPDATER.compareAndSet(this, current, next)) {
            return current != ClosedState.CLOSED && next == ClosedState.CLOSED;
        }
        return false;
    }

    public boolean tryOpenInbound() {
        ClosedState current = this.state;
        ClosedState next = current.openInbound();
        if (STATE_UPDATER.compareAndSet(this, current, next)) {
            return next != ClosedState.CLOSED;
        }
        return false;
    }

    public boolean tryOpenOutbound() {
        ClosedState current = this.state;
        ClosedState next = current.openOutbound();
        if (STATE_UPDATER.compareAndSet(this, current, next)) {
            return next != ClosedState.CLOSED;
        }
        return false;
    }

    public void close() {
        STATE_UPDATER.getAndSet(this, ClosedState.CLOSED);
    }

    public void open() {
        STATE_UPDATER.getAndSet(this, ClosedState.OPEN);
    }

    public boolean isClosed() {
        return this.state == ClosedState.CLOSED;
    }

    public boolean isInboundClosed() {
        return this.state.isInboundClosed();
    }

    public boolean isOutboundClosed() {
        return this.state.isOutboundClosed();
    }

    public boolean isOpen() {
        return this.state == ClosedState.OPEN;
    }

    public boolean isClosing() {
        return this.state.isClosing();
    }

    public static enum ClosedState {
        CLOSED,
        INBOUND_CLOSED,
        OUTBOUND_CLOSED,
        OPEN;


        public boolean isClosed() {
            return this == CLOSED;
        }

        public boolean isOpen() {
            return this == OPEN;
        }

        public boolean isInboundClosed() {
            return this == INBOUND_CLOSED || this == CLOSED;
        }

        public boolean isOutboundClosed() {
            return this == OUTBOUND_CLOSED || this == CLOSED;
        }

        public boolean isClosing() {
            return this == INBOUND_CLOSED || this == OUTBOUND_CLOSED;
        }

        private ClosedState closeInbound() {
            switch (this) {
                case OUTBOUND_CLOSED: {
                    return CLOSED;
                }
                case OPEN: {
                    return INBOUND_CLOSED;
                }
            }
            return this;
        }

        private ClosedState closeOutbound() {
            switch (this) {
                case INBOUND_CLOSED: {
                    return CLOSED;
                }
                case OPEN: {
                    return OUTBOUND_CLOSED;
                }
            }
            return this;
        }

        private ClosedState openInbound() {
            switch (this) {
                case INBOUND_CLOSED: {
                    return OPEN;
                }
                case CLOSED: {
                    return OUTBOUND_CLOSED;
                }
            }
            return this;
        }

        private ClosedState openOutbound() {
            switch (this) {
                case OUTBOUND_CLOSED: {
                    return OPEN;
                }
                case CLOSED: {
                    return INBOUND_CLOSED;
                }
            }
            return this;
        }
    }
}

