/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.response;

import com.pushtechnology.diffusion.client.session.AuthenticationException;
import com.pushtechnology.diffusion.client.session.ServerInitializingException;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentException;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentTransientException;
import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.nio.ByteBuffer;

public enum ResponseCode {
    OK(100, "Connected successfully", Type.SUCCESS),
    DOWNGRADE(102, "Server does not support the requested protocol level", Type.DOWNGRADE_REQUIRED),
    RECONNECTED(105, "Reconnected successfully", Type.SUCCESS),
    RECONNECTED_WITH_MESSAGE_LOSS(106, "Reconnected with message loss", Type.SUCCESS),
    REVERSE_CONNECTION_ACCEPTED(107, "Reverse connection accepted", Type.REVERSE_SUCCESS),
    LICENSE_EXCEEDED(113, "Connection rejected due to license limit", Type.FATAL),
    RECONNECTION_UNSUPPORTED(114, "Reconnection not supported by connector", Type.FATAL),
    CONNECTION_PROTOCOL_ERROR(115, "Connection failed - protocol error", Type.FATAL),
    AUTHENTICATION_FAILED(116, "Authentication failed", Type.AUTHENTICATION),
    UNKNOWN_SESSION(117, "Reconnection failed - the session is unknown", Type.FATAL),
    RECONNECTION_FAILED_MESSAGE_LOSS(118, "Reconnection failed due to message loss", Type.FATAL),
    REJECTED_SERVER_INITIALISING(119, "Connection rejected because the server is not ready.", Type.SERVER_INITIALIZING),
    PEER_CONNECTION_FAILED(1, "Peer connection failed", Type.FATAL),
    LOOPBACK_DENIED(2, "Loopback connection to same server denied", Type.FATAL),
    SECONDARY_ACCEPTOR_NOT_FOUND(3, "Secondary acceptor with matching name not found", Type.FATAL);

    private final byte value;
    private final String message;
    private final byte[] valueBytes;
    private final String description;
    private final Type type;
    private static final EnumConverter<ResponseCode> CONVERTER;

    private ResponseCode(int v, String message, Type type) {
        this.message = message;
        this.type = type;
        this.value = (byte)v;
        String valueAsString = Byte.toString(this.value);
        this.valueBytes = CharsetUtils.stringToASCII(valueAsString);
        this.description = this.name() + " - " + valueAsString + " " + message;
    }

    public final byte toByte() {
        return this.value;
    }

    public final String getMessage() {
        return this.message;
    }

    public final void putValueASCII(ByteBuffer buffer) {
        buffer.put(this.valueBytes);
    }

    public final boolean isSuccess() {
        return this.type == Type.SUCCESS;
    }

    public final void checkSuccess() throws SessionException {
        this.type.checkSuccess(this.getMessage());
    }

    public final String toString() {
        return this.description;
    }

    public static ResponseCode fromByte(byte b) {
        return CONVERTER.fromByte(b);
    }

    static {
        CONVERTER = new EnumConverter.Builder<ResponseCode>(ResponseCode.class).bimap(ResponseCode.OK.value, OK).bimap(ResponseCode.DOWNGRADE.value, DOWNGRADE).bimap(ResponseCode.RECONNECTED.value, RECONNECTED).bimap(ResponseCode.RECONNECTED_WITH_MESSAGE_LOSS.value, RECONNECTED_WITH_MESSAGE_LOSS).bimap(ResponseCode.REVERSE_CONNECTION_ACCEPTED.value, REVERSE_CONNECTION_ACCEPTED).bimap(ResponseCode.LICENSE_EXCEEDED.value, LICENSE_EXCEEDED).bimap(ResponseCode.RECONNECTION_UNSUPPORTED.value, RECONNECTION_UNSUPPORTED).bimap(ResponseCode.CONNECTION_PROTOCOL_ERROR.value, CONNECTION_PROTOCOL_ERROR).bimap(ResponseCode.AUTHENTICATION_FAILED.value, AUTHENTICATION_FAILED).bimap(ResponseCode.UNKNOWN_SESSION.value, UNKNOWN_SESSION).bimap(ResponseCode.RECONNECTION_FAILED_MESSAGE_LOSS.value, RECONNECTION_FAILED_MESSAGE_LOSS).bimap(ResponseCode.PEER_CONNECTION_FAILED.value, PEER_CONNECTION_FAILED).bimap(ResponseCode.REJECTED_SERVER_INITIALISING.value, REJECTED_SERVER_INITIALISING).bimap(ResponseCode.LOOPBACK_DENIED.value, LOOPBACK_DENIED).bimap(ResponseCode.SECONDARY_ACCEPTOR_NOT_FOUND.value, SECONDARY_ACCEPTOR_NOT_FOUND).build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Type {
        SUCCESS{

            @Override
            public void checkSuccess(String m) {
            }
        }
        ,
        DOWNGRADE_REQUIRED{

            @Override
            public void checkSuccess(String m) {
            }
        }
        ,
        FATAL{

            @Override
            public void checkSuccess(String m) throws SessionException {
                throw new SessionEstablishmentException(m);
            }
        }
        ,
        AUTHENTICATION{

            @Override
            public void checkSuccess(String m) throws SessionException {
                throw new AuthenticationException(m);
            }
        }
        ,
        TRANSIENT{

            @Override
            public void checkSuccess(String m) throws SessionException {
                throw new SessionEstablishmentTransientException(m);
            }
        }
        ,
        SERVER_INITIALIZING{

            @Override
            public void checkSuccess(String m) throws SessionException {
                throw new ServerInitializingException(m);
            }
        }
        ,
        REVERSE_SUCCESS{

            @Override
            public void checkSuccess(String m) {
            }
        };


        public abstract void checkSuccess(String var1) throws SessionException;
    }
}

