/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.response;

import com.pushtechnology.diffusion.clients.token.SessionToken;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import net.jcip.annotations.Immutable;

@Immutable
public final class ConnectionResponse {
    private final ResponseCode code;
    private final ProtocolVersion protocolVersion;
    private final InternalSessionId sessionId;
    private final SessionToken sessionToken;
    private final long systemPingPeriod;
    private final int recoverySequence;
    private final int maximumMessageSize;

    public static ConnectionResponse createConnectionResponse(ProtocolVersion protocolVersion, InternalSessionId sessionId, SessionToken sessionToken, long systemPingPeriod, int maximumMessageSize) {
        return new ConnectionResponse(ResponseCode.OK, sessionId, sessionToken, protocolVersion, systemPingPeriod, 0, maximumMessageSize);
    }

    public static ConnectionResponse createReconnectionResponse(ResponseCode responseCode, ProtocolVersion protocolVersion, InternalSessionId sessionId, SessionToken sessionToken, long systemPingPeriod, int recoverySequence) {
        if (responseCode != ResponseCode.RECONNECTED_WITH_MESSAGE_LOSS && responseCode != ResponseCode.RECONNECTED) {
            throw new IllegalArgumentException("Unknown reconnection code: " + String.valueOf((Object)responseCode));
        }
        return new ConnectionResponse(responseCode, sessionId, sessionToken, protocolVersion, systemPingPeriod, recoverySequence, -1);
    }

    public static ConnectionResponse createResponse(ProtocolVersion protocolVersion, ResponseCode responseCode) {
        return new ConnectionResponse(ConnectionResponse.rejectedResponseCodeForProtocol(protocolVersion, responseCode), null, null, protocolVersion, -1L, 0, -1);
    }

    private static ResponseCode rejectedResponseCodeForProtocol(ProtocolVersion protocolVersion, ResponseCode responseCode) {
        if (responseCode == ResponseCode.REJECTED_SERVER_INITIALISING && protocolVersion.isEarlierThan(ProtocolVersion.PROTOCOL_18_VERSION)) {
            return ResponseCode.CONNECTION_PROTOCOL_ERROR;
        }
        return responseCode;
    }

    ConnectionResponse(ResponseCode code, InternalSessionId sessionId, SessionToken sessionToken, ProtocolVersion protocolVersion, long systemPingPeriod, int recoverySequence, int maximumMessageSize) {
        this.code = code;
        this.sessionId = sessionId;
        this.sessionToken = sessionToken;
        this.protocolVersion = protocolVersion;
        this.systemPingPeriod = systemPingPeriod;
        this.recoverySequence = recoverySequence;
        this.maximumMessageSize = maximumMessageSize;
    }

    public InternalSessionId getSessionId() {
        return this.sessionId;
    }

    public SessionToken getSessionToken() {
        return this.sessionToken;
    }

    public ResponseCode getCode() {
        return this.code;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getSystemPingPeriod() {
        return this.systemPingPeriod;
    }

    public int getRecoverySequence() throws IllegalStateException {
        if (this.code != ResponseCode.RECONNECTED) {
            throw new IllegalStateException("Response code : " + String.valueOf((Object)this.code));
        }
        return this.recoverySequence;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public String toString() {
        return this.code.toString() + " " + String.valueOf((Object)this.getProtocolVersion()) + " session " + String.valueOf(this.getSessionId());
    }
}

