/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.request;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.comms.connection.ConnectionCapabilities;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.request.AbstractConnectRequest;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReverseConnectionRequest
extends AbstractConnectRequest {
    private final String theRemoteServerName;
    private final String theRequestId;
    private final String theServerUUID;

    public ReverseConnectionRequest(String remoteServerName, String requestId, String serverUUID, ProtocolVersion protocolVersion) {
        super(protocolVersion, InternalConnectionType.WEBSOCKET_REVERSE_SERVER, ConnectionCapabilities.NO_CAPABILITIES);
        this.theRemoteServerName = remoteServerName;
        this.theRequestId = requestId;
        this.theServerUUID = serverUUID;
    }

    public String getRemoteServerName() {
        return this.theRemoteServerName;
    }

    public String getRequestId() {
        return this.theRequestId;
    }

    public String getServerUUID() {
        return this.theServerUUID;
    }

    @Override
    public ReverseConnectionRequest withProtocolVersion(ProtocolVersion requestedVersion) {
        return new ReverseConnectionRequest(this.getRemoteServerName(), this.getRequestId(), this.getServerUUID(), requestedVersion);
    }

    public String toString() {
        return String.format("%s(%s, %s, %s, %s, %s, %s)", new Object[]{this.getClass().getSimpleName(), this.getProtocolVersion(), this.getConnectionType(), this.getCapabilities(), this.getRemoteServerName(), this.getRequestId(), this.getServerUUID()});
    }
}

