/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.request;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsImpl;
import com.pushtechnology.diffusion.client.types.impl.CredentialsSerialiser;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.http.ParseHTTPException;
import com.pushtechnology.diffusion.io.serialisation.Serialiser;
import com.pushtechnology.diffusion.utils.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class Protocol4CredentialsTunnel {
    public static final Protocol4CredentialsTunnel INSTANCE = new Protocol4CredentialsTunnel();
    private final Serialiser<Credentials> serialiser;

    private Protocol4CredentialsTunnel() {
        this(new CredentialsSerialiser());
    }

    Protocol4CredentialsTunnel(Serialiser<Credentials> credentialsSerialiser) {
        this.serialiser = credentialsSerialiser;
    }

    public String encodeAsString(Credentials v5) {
        IBytesOutputStreamImpl baos = new IBytesOutputStreamImpl();
        try {
            this.serialiser.write(baos, v5);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return Base64.encode(baos.toByteArray());
    }

    public Credentials decodeFromString(String s) throws ParseHTTPException {
        byte[] decoded;
        if (s == null || s.isEmpty()) {
            return CredentialsImpl.NO_CREDENTIALS;
        }
        try {
            decoded = Base64.decode(s);
        }
        catch (IllegalArgumentException e) {
            throw new ParseHTTPException("Corrupt credentials", e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(decoded);
        try {
            return (Credentials)this.serialiser.read(in);
        }
        catch (IOException e) {
            throw new ParseHTTPException("Corrupt credentials", e);
        }
    }
}

