/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.ProxyConnector;
import com.pushtechnology.diffusion.comms.connection.SocketChannelFactory;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.time.SystemTime;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

@Immutable
final class SocketChannelFactoryImpl
implements SocketChannelFactory {
    private static final Logger LOG = I18nLogger.getLogger(SocketChannelFactoryImpl.class);
    private final AtomicBoolean inputBufferOversizedWarned = new AtomicBoolean();
    private final AtomicBoolean outputBufferOversizedWarned = new AtomicBoolean();

    SocketChannelFactoryImpl() {
    }

    @Override
    public SocketChannel connect(ServerDetails serverDetails) throws ConnectionException {
        ProxyConnector proxyConnector = serverDetails.getProxyConnector();
        if (proxyConnector != null) {
            return proxyConnector.sendConnectRequest(serverDetails.getHost(), serverDetails.getPort());
        }
        try {
            return this.connectDirectly(serverDetails);
        }
        catch (IOException | UnresolvedAddressException e) {
            throw new ConnectionException(String.format("Failed to connect to %s: %s", serverDetails, e.getLocalizedMessage()), e);
        }
    }

    private SocketChannel connectDirectly(ServerDetails socketDetails) throws IOException {
        SocketChannel channel = SocketChannel.open();
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}.connectDirectly(), opened: {} {}", this.getClass().getSimpleName(), channel.hashCode(), channel);
        }
        channel.configureBlocking(true);
        Socket socket = channel.socket();
        socket.setTcpNoDelay(true);
        this.setSendBufferSize(socket, socketDetails.getOutputBufferSize());
        this.setReceiveBufferSize(socket, socketDetails.getInputBufferSize());
        SocketAddress localSocketAddress = socketDetails.getLocalSocketAddress();
        if (localSocketAddress != null) {
            try {
                channel.bind(localSocketAddress);
            }
            catch (NoSuchMethodError e) {
                LOG.info("COMMS_LOCAL_BIND_FAILED", (Object)localSocketAddress);
            }
            catch (BindException e) {
                throw new ConnectionException(String.format("Cannot bind socket to local address \"%s\": %s", localSocketAddress, e.getLocalizedMessage()), e);
            }
        }
        SocketChannelFactoryImpl.connectSocket(channel, new InetSocketAddress(socketDetails.getHost(), socketDetails.getPort()), socketDetails.getConnectionTimeout());
        return channel;
    }

    private void setSendBufferSize(Socket socket, int sendBufferSize) throws SocketException {
        socket.setSendBufferSize(sendBufferSize);
        int actualSendBufferSize = socket.getSendBufferSize();
        if (actualSendBufferSize < sendBufferSize && this.outputBufferOversizedWarned.compareAndSet(false, true)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("COMMS_UNABLE_TO_ALLOCATE_SEND_BUFFER", "Outbound Connection", sendBufferSize, actualSendBufferSize);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Outbound Connection: socket send buffer requested was allocated: {}", (Object)actualSendBufferSize);
        }
    }

    private void setReceiveBufferSize(Socket socket, int receiveBufferSize) throws SocketException {
        socket.setReceiveBufferSize(receiveBufferSize);
        int actualReceiveBufferSize = socket.getReceiveBufferSize();
        if (actualReceiveBufferSize < receiveBufferSize && this.inputBufferOversizedWarned.compareAndSet(false, true)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("COMMS_UNABLE_TO_ALLOCATE_RECEIVE_BUFFER", "Outbound Connection", receiveBufferSize, actualReceiveBufferSize);
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Outbound Connection: socket receive buffer requested was allocated: {}", (Object)actualReceiveBufferSize);
        }
    }

    private static void connectSocket(SocketChannel channel, SocketAddress endpoint, long timeout) throws IOException {
        Selector selector;
        try {
            selector = Selector.open();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(channel);
            throw e;
        }
        channel.configureBlocking(false);
        try {
            if (channel.connect(endpoint)) {
                return;
            }
            long timeoutLeft = timeout;
            long endTime = SystemTime.currentTimeMillis() + timeout;
            channel.register(selector, 8);
            do {
                int ret;
                if ((ret = selector.select(timeoutLeft)) > 0 && channel.finishConnect()) {
                    selector.close();
                    channel.configureBlocking(true);
                    return;
                }
                timeoutLeft = endTime - SystemTime.currentTimeMillis();
            } while (timeout <= 0L || timeoutLeft > 0L);
            selector.close();
            channel.configureBlocking(true);
            throw new SocketTimeoutException("SocketChannel.connect() timed out after " + timeout + "ms");
        }
        catch (IOException | UnresolvedAddressException e) {
            selector.close();
            IOUtils.closeQuietly(channel);
            throw e;
        }
    }
}

