/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

public enum ProtocolVersion {
    UNKNOWN_EARLY_VERSION(0),
    PROTOCOL_9_VERSION(9),
    PROTOCOL_10_VERSION(10),
    PROTOCOL_11_VERSION(11),
    PROTOCOL_12_VERSION(12),
    PROTOCOL_13_VERSION(13),
    PROTOCOL_14_VERSION(14),
    PROTOCOL_15_VERSION(15),
    PROTOCOL_16_VERSION(16),
    PROTOCOL_17_VERSION(17),
    PROTOCOL_18_VERSION(18),
    PROTOCOL_19_VERSION(19),
    PROTOCOL_20_VERSION(20),
    PROTOCOL_21_VERSION(21),
    PROTOCOL_22_VERSION(22),
    PROTOCOL_23_VERSION(23),
    PROTOCOL_24_VERSION(24),
    PROTOCOL_25_VERSION(25),
    PROTOCOL_26_VERSION(26),
    PROTOCOL_27_VERSION(27),
    PROTOCOL_28_VERSION(28),
    PROTOCOL_29_VERSION(29),
    UNKNOWN_LATER_VERSION(127);

    public static final ProtocolVersion CURRENT_VERSION;
    private byte value;
    private static final ProtocolVersion[] FROM_OFFSET_BYTE;

    private ProtocolVersion(int value) {
        this.value = (byte)value;
    }

    public byte asByte() {
        return this.value;
    }

    public boolean isEarlierThan(ProtocolVersion other) {
        return this.value < other.value;
    }

    public boolean isLaterThan(ProtocolVersion other) {
        return this.value > other.value;
    }

    public boolean isAtLeast(ProtocolVersion other) {
        return !this.isEarlierThan(other);
    }

    public static ProtocolVersion fromASCII(String ascii) {
        return ProtocolVersion.fromByte(Byte.parseByte(ascii));
    }

    public static ProtocolVersion fromByte(byte b) {
        int v = (b & 0xFF) - ProtocolVersion.PROTOCOL_9_VERSION.value;
        if (v < 0) {
            return UNKNOWN_EARLY_VERSION;
        }
        if (v >= FROM_OFFSET_BYTE.length) {
            return UNKNOWN_LATER_VERSION;
        }
        return FROM_OFFSET_BYTE[v];
    }

    static {
        CURRENT_VERSION = PROTOCOL_29_VERSION;
        FROM_OFFSET_BYTE = new ProtocolVersion[]{PROTOCOL_9_VERSION, PROTOCOL_10_VERSION, PROTOCOL_11_VERSION, PROTOCOL_12_VERSION, PROTOCOL_13_VERSION, PROTOCOL_14_VERSION, PROTOCOL_15_VERSION, PROTOCOL_16_VERSION, PROTOCOL_17_VERSION, PROTOCOL_18_VERSION, PROTOCOL_19_VERSION, PROTOCOL_20_VERSION, PROTOCOL_21_VERSION, PROTOCOL_22_VERSION, PROTOCOL_23_VERSION, PROTOCOL_24_VERSION, PROTOCOL_25_VERSION, PROTOCOL_26_VERSION, PROTOCOL_27_VERSION, PROTOCOL_28_VERSION, PROTOCOL_29_VERSION};
    }
}

