/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.message.MessageChannel;
import com.pushtechnology.diffusion.messagequeue.OutboundMessageQueue;
import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.diagnostics.SessionFields;
import com.pushtechnology.diffusion.multiplexer.messageclient.AbstractMessageQueueMultiplexerClient;
import com.pushtechnology.diffusion.multiplexer.messageclient.MessageQueueMultiplexerClientCallbacks;
import com.pushtechnology.diffusion.reports.Record;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class OutboundMultiplexerClient
extends AbstractMessageQueueMultiplexerClient<Multiplexer, MessageQueueMultiplexerClientCallbacks> {
    OutboundMultiplexerClient(Multiplexer multiplexer, MessageQueueMultiplexerClientCallbacks multiplexerCallbacks, OutboundMessageQueue messageQueue, int recoveryBufferSize) {
        super(multiplexer, messageQueue, recoveryBufferSize, multiplexerCallbacks);
    }

    public void completeConnection(MessageChannel messageChannel) {
        this.enqueueEvent(state -> {
            this.register(state);
            this.setMessageChannel(state, messageChannel);
        });
    }

    public void unregister() {
        this.enqueueEvent(new UnregisterEvent());
    }

    public void recoverMessages(int recipientLastSequence) {
        this.enqueueEvent(state -> this.recoverMessages(state, recipientLastSequence));
    }

    public void resetClientSequence() {
        this.enqueueEvent(state -> this.resetOutboundSequenceAndRecoveryBuffer());
    }

    @Override
    @MultiplexerOnly
    public void diagnosticReport(Record<SessionFields> record) {
        super.diagnosticReport(record);
        record.set(SessionFields.TYPE, "remote");
    }

    private final class UnregisterEvent
    implements MultiplexerEvent<MultiplexerState> {
        private UnregisterEvent() {
        }

        @Override
        public void handleEvent(MultiplexerState state) {
            OutboundMultiplexerClient.this.unregister(state);
        }
    }
}

