/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionCallbacks;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionMessageHandler;
import net.jcip.annotations.Immutable;

@Immutable
final class OutboundConnectionParameters {
    private final ServerDetails serverDetails;
    private final int reconnectPeriod;
    private final OutboundConnectionMessageHandler messageHandler;
    private final OutboundConnectionCallbacks connectionCallbacks;

    OutboundConnectionParameters(ServerDetails serverDetails, int reconnectPeriod, OutboundConnectionMessageHandler messageHandler, OutboundConnectionCallbacks connectionCallbacks) {
        this.serverDetails = serverDetails;
        this.reconnectPeriod = reconnectPeriod;
        this.messageHandler = messageHandler;
        this.connectionCallbacks = connectionCallbacks;
    }

    public int getInputBufferSize() {
        return this.serverDetails.getInputBufferSize();
    }

    public String getServerHost() {
        return this.serverDetails.getHost();
    }

    public int getServerPort() {
        return this.serverDetails.getPort();
    }

    public OutboundConnectionMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public OutboundConnectionCallbacks getConnectionCallbacks() {
        return this.connectionCallbacks;
    }

    public int getReconnectPeriod() {
        return this.reconnectPeriod;
    }

    public String toString() {
        StringBuilder uri = new StringBuilder();
        switch (this.serverDetails.getTransport()) {
            case HTTP_POLLING: {
                uri.append("xhr");
                break;
            }
            case WEBSOCKET: {
                uri.append("ws");
                break;
            }
            default: {
                uri.append("deprecated");
            }
        }
        if (this.serverDetails.isSecureConnection()) {
            uri.append('s');
        }
        uri.append("://").append(this.getServerHost()).append(':').append(this.getServerPort());
        return uri.toString();
    }
}

