/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeResult;
import com.pushtechnology.diffusion.comms.connection.OutboundConnection;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionFactoryParameters;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionParameters;
import com.pushtechnology.diffusion.comms.connection.OutboundMultiplexerClient;
import com.pushtechnology.diffusion.comms.connection.ReconnectionParameters;
import com.pushtechnology.diffusion.comms.connection.request.ConnectOrReconnectRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReconnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.exceptions.CustomCloseLogging;
import com.pushtechnology.diffusion.exceptions.DiffusionInterruptedException;
import com.pushtechnology.diffusion.flowcontrol.FlowControl;
import com.pushtechnology.diffusion.flowcontrol.PendingOperations;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.io.nio.ReadChannelHandler;
import com.pushtechnology.diffusion.io.nio.SelectorOperations;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.CloseRequestMessage;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageChannel;
import com.pushtechnology.diffusion.message.MessageChannelClosedReason;
import com.pushtechnology.diffusion.message.MessageChannelListener;
import com.pushtechnology.diffusion.message.ParseMessageException;
import com.pushtechnology.diffusion.messagequeue.OutboundMessageQueue;
import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerEvent;
import com.pushtechnology.diffusion.multiplexer.MultiplexerState;
import com.pushtechnology.diffusion.multiplexer.messageclient.MessageQueueMultiplexerClientCallbacks;
import com.pushtechnology.diffusion.threads.InboundThreadOnly;
import com.pushtechnology.diffusion.time.SystemTime;
import com.pushtechnology.diffusion.utils.Exceptions;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
final class OutboundConnectionImpl
implements OutboundConnection {
    private static final Logger LOG = I18nLogger.getLogger(OutboundConnectionImpl.class);
    private final OutboundConnectionFactoryParameters factoryParameters;
    private final OutboundConnectionParameters connectionParameters;
    private final ReconnectionParameters reconnectionParameters;
    private final FlowControl flowControl;
    private final PendingOperations pendingOperations;
    private final OutboundMultiplexerClient multiplexerClient;
    private final MessageChannelListenerImpl messageListener;
    @GuardedBy(value="this")
    private MessageChannel messageChannel;
    @GuardedBy(value="this")
    private State state = State.CONNECTING;
    private volatile ConnectionResponse lastResponse;
    private volatile int lastServerSequence = 0;
    private static final AtomicIntegerFieldUpdater<OutboundConnectionImpl> LAST_SERVER_SEQUENCE = AtomicIntegerFieldUpdater.newUpdater(OutboundConnectionImpl.class, "lastServerSequence");

    OutboundConnectionImpl(Multiplexer multiplexer, OutboundMessageQueue messageQueue, FlowControl flowControl, PendingOperations pendingOperations, OutboundConnectionFactoryParameters factoryParameters, OutboundConnectionParameters connectionParameters, ReconnectionParameters reconnectionParameters, ConnectionResponse connectionResponse, int recoveryBufferSize, Object inboundThreadKey) {
        this.factoryParameters = factoryParameters;
        this.reconnectionParameters = reconnectionParameters;
        this.connectionParameters = connectionParameters;
        this.messageListener = new MessageChannelListenerImpl(inboundThreadKey);
        this.multiplexerClient = new OutboundMultiplexerClient(multiplexer, new MultiplexerCallbacksImpl(), messageQueue, recoveryBufferSize);
        this.pendingOperations = pendingOperations;
        this.flowControl = flowControl;
        this.lastResponse = connectionResponse;
    }

    @Override
    public ConnectionResponse getResponse() {
        return this.lastResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MessageChannel channel;
        boolean connected;
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            boolean bl = connected = this.state == State.CONNECTED;
            if (!this.changeState(State.CLOSING)) {
                return;
            }
            channel = this.messageChannel;
        }
        this.flowControl.stopLogging();
        try {
            if (connected) {
                this.gracefulShutdown(channel);
            } else if (channel != null) {
                channel.requestLocalClose();
            } else {
                this.multiplexerClient.unregister();
            }
        }
        finally {
            this.changeState(State.CLOSED);
            this.connectionParameters.getConnectionCallbacks().onClosed();
        }
    }

    private void gracefulShutdown(MessageChannel channel) {
        this.multiplexerClient.enqueueEvent(new DropQueueAndSendClose());
        try {
            if (!this.awaitTransitionFromClosing(this.factoryParameters.getServerCloseGracePeriod())) {
                channel.requestLocalClose();
            }
        }
        catch (InterruptedException e) {
            channel.close(MessageChannelClosedReason.UNEXPECTED_ERROR, e);
            throw new DiffusionInterruptedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitTransitionFromClosing(int timeoutMillis) throws InterruptedException {
        long start;
        long now = start = SystemTime.currentTimeMillis();
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            while (this.state == State.CLOSING) {
                long remaining = (long)timeoutMillis - (now - start);
                if (remaining <= 0L) {
                    return false;
                }
                this.wait(remaining);
                now = SystemTime.currentTimeMillis();
            }
            return true;
        }
    }

    @Override
    public void abort() {
        boolean changedState = this.changeState(State.CLOSING);
        this.multiplexerClient.closeMessageChannelAndUnregister(() -> this.executeInInboundThread(() -> {
            OutboundConnectionImpl outboundConnectionImpl = this;
            synchronized (outboundConnectionImpl) {
                this.messageChannel = null;
                this.changeState(State.CLOSED);
                this.notifyAll();
            }
            if (changedState) {
                this.connectionParameters.getConnectionCallbacks().onClosed();
            }
            LOG.debug("{} closed", (Object)this);
        }));
    }

    private void executeInInboundThread(Runnable action) {
        this.factoryParameters.getInboundThreadPool().execute(this.messageListener.inboundThreadKey, action::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(MessageChannelClosedReason reason, Throwable cause) {
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            if (this.messageChannel != null) {
                this.messageChannel.close(reason, cause);
            }
        }
    }

    private void dispatchCloseComplete(MessageChannelClosedReason reason, Throwable cause) {
        LOG.trace("dispatchCloseComplete {}", (Object)reason, (Object)cause);
        this.executeInInboundThread(() -> {
            if (reason == MessageChannelClosedReason.MESSAGE_QUEUE_LIMIT_REACHED || reason == MessageChannelClosedReason.MESSAGES_LOST) {
                OutboundConnectionImpl outboundConnectionImpl = this;
                synchronized (outboundConnectionImpl) {
                    this.changeState(State.FAILED);
                    this.messageChannel = null;
                }
                this.close();
            } else {
                MessageChannel channel;
                boolean lost;
                State oldState;
                OutboundConnectionImpl outboundConnectionImpl = this;
                synchronized (outboundConnectionImpl) {
                    oldState = this.state;
                    lost = this.changeState(State.FAILED);
                    this.notifyAll();
                    channel = this.messageChannel;
                    this.messageChannel = null;
                    if (!lost) {
                        this.multiplexerClient.unregister();
                    }
                }
                if (lost) {
                    this.logClose(channel, reason, cause, oldState == State.CLOSING);
                    if (reason == MessageChannelClosedReason.MESSAGE_TOO_LARGE) {
                        this.connectionParameters.getConnectionCallbacks().onMaximumMessageSizeExceeded();
                    } else {
                        this.connectionParameters.getConnectionCallbacks().onLost();
                    }
                }
            }
        });
    }

    @Override
    public void sendMessage(Message message) {
        this.flowControl.apply();
        this.multiplexerClient.enqueueEvent(new SendMessage(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect(Consumer<ConnectionResponse> onConnection) throws IOException {
        ConnectionHandshakeResult handshakeResult;
        if (this.reconnectionParameters == null) {
            throw new UnsupportedOperationException("Reconnection not supported: " + String.valueOf(this));
        }
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            if (!this.changeState(State.CONNECTING)) {
                throw new IllegalStateException("Not disconnected: " + String.valueOf(this));
            }
        }
        int availableClientSequence = this.multiplexerClient.getAvailableSequence();
        ReconnectionRequest request = new ReconnectionRequest(this.lastResponse.getProtocolVersion(), this.reconnectionParameters.getConnectionType(), this.reconnectionParameters.getCapabilities(), this.lastResponse.getSessionToken(), availableClientSequence, this.lastServerSequence);
        NetworkContext networkContext = this.factoryParameters.getNetworkContexts().next();
        try {
            handshakeResult = this.factoryParameters.getCascadeDriver().reconnect(this.reconnectionParameters.getServerDetails(), networkContext, request, this.reconnectionParameters.getEventListener(), this.factoryParameters.getMaximumMessageSize());
        }
        catch (IOException e) {
            this.changeState(State.FAILED);
            throw e;
        }
        ConnectionResponse response = handshakeResult.getConnectionResponse();
        if (response.getCode() == ResponseCode.RECONNECTED_WITH_MESSAGE_LOSS) {
            LOG.warn("COMMS_CONNECTION_RECONNECTED_WITH_MESSAGE_LOSS", (Object)this);
            LAST_SERVER_SEQUENCE.set(this, 0);
            this.multiplexerClient.resetClientSequence();
        } else {
            this.multiplexerClient.recoverMessages(response.getRecoverySequence() - 1);
            LOG.info("COMMS_CONNECTION_RECONNECTED_WITH_MESSAGE_RECOVERY", (Object)this);
        }
        this.lastResponse = response;
        this.completeConnection(request, handshakeResult, networkContext.getSelector(), onConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeConnection(ConnectOrReconnectRequest connectionRequest, ConnectionHandshakeResult handshakeResult, SelectorOperations selector, Consumer<ConnectionResponse> onConnection) {
        MessageChannel newMessageChannel = handshakeResult.getMessageChannelFactory().create(handshakeResult.getConnectionResponse(), handshakeResult.getChannel(), handshakeResult.getServerDetails(), connectionRequest.getConnectionType(), connectionRequest.getCapabilities(), this.multiplexerClient, this.messageListener, this.factoryParameters.getMaximumMessageSize());
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            if (!this.changeState(State.CONNECTED)) {
                throw new IllegalStateException("Not connecting: " + String.valueOf(this));
            }
            this.messageChannel = newMessageChannel;
        }
        this.flowControl.startLogging();
        this.multiplexerClient.completeConnection(newMessageChannel);
        onConnection.accept(handshakeResult.getConnectionResponse());
        ReadChannelHandler readbleMessageChannel = (ReadChannelHandler)((Object)newMessageChannel);
        LOG.debug("Registering for initial read");
        selector.registerForInitialRead(this.factoryParameters.getInboundThreadPool(), this.connectionParameters.getInputBufferSize(), readbleMessageChannel, handshakeResult.getInitialBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changeState(State newState) {
        State oldState;
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            oldState = this.state;
            if (!this.state.allowedTransition(newState)) {
                return false;
            }
            this.state = newState;
        }
        LOG.debug("{}: {} -> {}", new Object[]{this, oldState, newState});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String stateDescription;
        ConnectionResponse response = this.lastResponse;
        String identity = response != null ? response.getSessionId().toString() : Integer.toHexString(this.hashCode());
        OutboundConnectionImpl outboundConnectionImpl = this;
        synchronized (outboundConnectionImpl) {
            stateDescription = this.state.toString();
        }
        return "Connection " + identity + " to " + String.valueOf(this.connectionParameters) + " " + stateDescription;
    }

    private void logClose(MessageChannel channel, MessageChannelClosedReason reason, Throwable cause, boolean expectEOF) {
        if (cause == null || expectEOF && (cause instanceof EOFException || cause instanceof ClosedChannelException)) {
            return;
        }
        String acceptableClose = Exceptions.acceptableCloseDescription(cause);
        if (acceptableClose != null) {
            LOG.info("IO_CONNECTION_LOST", (Object)this, (Object)acceptableClose);
            LOG.debug("{} : {} {}", new Object[]{channel, reason, acceptableClose, cause});
        } else if (cause instanceof CustomCloseLogging && ((CustomCloseLogging)((Object)cause)).getOmitStackTrace()) {
            LOG.warn("IO_MESSAGECHANNEL_EXCEPTION", (Object)channel, (Object)reason);
        } else {
            LOG.warn("IO_MESSAGECHANNEL_EXCEPTION", new Object[]{channel, reason, cause});
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum State {
        CONNECTING{

            @Override
            boolean allowedTransition(State newState) {
                return newState == CONNECTED || newState == FAILED || newState == CLOSING;
            }
        }
        ,
        CONNECTED{

            @Override
            boolean allowedTransition(State newState) {
                return newState == FAILED || newState == CLOSING;
            }
        }
        ,
        CLOSING{

            @Override
            boolean allowedTransition(State newState) {
                return newState == CLOSED;
            }
        }
        ,
        CLOSED{

            @Override
            boolean allowedTransition(State newState) {
                return false;
            }
        }
        ,
        FAILED{

            @Override
            boolean allowedTransition(State newState) {
                return newState == CONNECTING || newState == CLOSING;
            }
        };


        abstract boolean allowedTransition(State var1);
    }

    private final class MessageChannelListenerImpl
    implements MessageChannelListener {
        private final Object inboundThreadKey;

        MessageChannelListenerImpl(Object inboundThreadKey) {
            this.inboundThreadKey = inboundThreadKey;
        }

        @Override
        @InboundThreadOnly
        public void messageReceived(Message message) {
            LAST_SERVER_SEQUENCE.lazySet(OutboundConnectionImpl.this, OutboundConnectionImpl.this.lastServerSequence + 1);
            try {
                OutboundConnectionImpl.this.connectionParameters.getMessageHandler().handleMessage(message, OutboundConnectionImpl.this);
            }
            catch (ParseMessageException e) {
                LOG.error("COMMS_CONNECTION_CLIENT_INBOUND_PROCESSING_FAILURE", e);
                OutboundConnectionImpl.this.closeConnection(MessageChannelClosedReason.UNEXPECTED_ERROR, e);
            }
        }

        @Override
        public void updateInboundStatistics(int messageCount, int billedMessageCount, int bytesReceived) {
        }

        @Override
        public void messageSendComplete(MultiplexerState multiplexerState, MessageChannelListener.SendResult result, int messageCount, int billedMessageCount, int bytesWritten, long startTime) {
        }

        @Override
        public void messageChannelClosed(MessageChannelClosedReason reason, Throwable cause) {
            OutboundConnectionImpl.this.dispatchCloseComplete(reason, cause);
        }

        @Override
        public Object inboundThreadAffinityKey() {
            return this.inboundThreadKey;
        }
    }

    private final class MultiplexerCallbacksImpl
    implements MessageQueueMultiplexerClientCallbacks {
        private MultiplexerCallbacksImpl() {
        }

        @Override
        public long getReconnectPeriod() {
            return OutboundConnectionImpl.this.connectionParameters.getReconnectPeriod();
        }

        @Override
        public String toString() {
            return OutboundConnectionImpl.this.toString();
        }
    }

    private final class DropQueueAndSendClose
    implements MultiplexerEvent<MultiplexerState> {
        private DropQueueAndSendClose() {
        }

        @Override
        public void handleEvent(MultiplexerState multiplexerState) {
            OutboundConnectionImpl.this.multiplexerClient.getMessageQueue().clear();
            OutboundConnectionImpl.this.multiplexerClient.sendMessage(multiplexerState, CloseRequestMessage.INSTANCE);
        }
    }

    private final class SendMessage
    implements MultiplexerEvent<MultiplexerState> {
        private final Message message;

        SendMessage(Message message) {
            this.message = message;
            OutboundConnectionImpl.this.pendingOperations.increment();
        }

        @Override
        public void handleEvent(MultiplexerState multiplexerState) {
            OutboundConnectionImpl.this.pendingOperations.decrement();
            OutboundConnectionImpl.this.multiplexerClient.sendMessage(multiplexerState, this.message);
        }
    }
}

