/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.comms.connection.CascadeDriver;
import com.pushtechnology.diffusion.comms.connection.NetworkContextPool;
import com.pushtechnology.diffusion.comms.connection.ReverseSecondaryConnector;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import net.jcip.annotations.Immutable;

@Immutable
final class OutboundConnectionFactoryParameters {
    private static final String SERVER_CLOSE_GRACE_PERIOD_PROPERTY = "diffusion.client.close.timeout2";
    private final NetworkContextPool networkContexts;
    private final ExecutionPool inboundThreadPool;
    private final int serverCloseGracePeriod;
    private final int maximumMessageSize;
    private final CascadeDriver cascadeDriver;
    private final ReverseSecondaryConnector reverseSecondaryConnector;

    OutboundConnectionFactoryParameters(ExecutionPool inboundThreadPool, NetworkContextPool networkContexts, int maximumMessageSize, CascadeDriver cascadeDriver, ReverseSecondaryConnector reverseSecondaryConnector) {
        this.inboundThreadPool = inboundThreadPool;
        this.networkContexts = networkContexts;
        this.maximumMessageSize = maximumMessageSize;
        this.cascadeDriver = cascadeDriver;
        this.reverseSecondaryConnector = reverseSecondaryConnector;
        this.serverCloseGracePeriod = ConfigurationUtils.getIntegerSystemProperty(SERVER_CLOSE_GRACE_PERIOD_PROPERTY, 1000);
    }

    public NetworkContextPool getNetworkContexts() {
        return this.networkContexts;
    }

    public ExecutionPool getInboundThreadPool() {
        return this.inboundThreadPool;
    }

    public int getServerCloseGracePeriod() {
        return this.serverCloseGracePeriod;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public CascadeDriver getCascadeDriver() {
        return this.cascadeDriver;
    }

    public ReverseSecondaryConnector getReverseSecondaryConnector() {
        return this.reverseSecondaryConnector;
    }
}

