/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactory;
import com.pushtechnology.diffusion.comms.connection.SocketChannelFactory;
import com.pushtechnology.diffusion.comms.connection.SocketChannelFactoryImpl;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.io.nio.SSLNetworkChannel;
import com.pushtechnology.diffusion.utils.io.IOUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import net.jcip.annotations.Immutable;

@Immutable
public final class NetworkChannelFactoryImpl
implements NetworkChannelFactory {
    private final SocketChannelFactory socketChannelFactory;

    public NetworkChannelFactoryImpl() {
        this(new SocketChannelFactoryImpl());
    }

    NetworkChannelFactoryImpl(SocketChannelFactory socketChannelFactory) {
        this.socketChannelFactory = socketChannelFactory;
    }

    @Override
    public NetworkChannel createChannel(ServerDetails serverDetails, ByteBuffer initialBuffer, NetworkContext networkContext) throws ConnectionException {
        serverDetails.disableSSLHostVerification();
        SocketChannel socketChannel = this.socketChannelFactory.connect(serverDetails);
        NetworkChannel plainChannel = new NetworkChannel(socketChannel, networkContext);
        return this.createChannel(socketChannel, plainChannel, serverDetails, initialBuffer);
    }

    @Override
    public NetworkChannel createReverseChannel(ServerDetails serverDetails, ByteBuffer initialBuffer, NetworkChannel networkChannel) throws ConnectionException {
        return this.createChannel(networkChannel.getSocketChannel(), networkChannel, serverDetails, initialBuffer);
    }

    private NetworkChannel createChannel(SocketChannel socketChannel, NetworkChannel plainChannel, ServerDetails serverDetails, ByteBuffer initialBuffer) throws ConnectionException {
        if (serverDetails.isSecureConnection()) {
            try {
                String hostName = serverDetails.getHost();
                SSLNetworkChannel sslChannel = new SSLNetworkChannel(plainChannel, serverDetails.getSSLContext(), true, hostName, serverDetails.isSSLHostVerificationDisabled() ? null : hostName, serverDetails.getInputBufferSize(), serverDetails.getOutputBufferSize());
                try {
                    sslChannel.handShake(initialBuffer, serverDetails.getWriteTimeout());
                    return sslChannel;
                }
                catch (IOException ioe) {
                    sslChannel.close();
                    throw new ConnectionException(String.format("Failed to connect to %s: %s", serverDetails, ioe.getLocalizedMessage()), ioe);
                }
            }
            catch (NoSuchAlgorithmException e) {
                IOUtils.closeQuietly(socketChannel);
                throw new ConnectionException("Connection to " + String.valueOf(serverDetails) + " has failed", e);
            }
        }
        return plainChannel;
    }
}

