/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

public interface ConnectionHandshakeEventListener {
    public static final ConnectionHandshakeEventListener NOOP = new Noop();
    public static final ConnectionHandshakeEventListener LOGGING = new Logging();

    public void onConnection();

    public void onConnectionAttempt(SessionAttributes.Transport var1);

    public void onTransportsExhausted();

    public void onFatalConnectionException();

    @Immutable
    public static final class Noop
    implements ConnectionHandshakeEventListener {
        private Noop() {
        }

        @Override
        public void onConnection() {
        }

        @Override
        public void onConnectionAttempt(SessionAttributes.Transport transport) {
        }

        @Override
        public void onTransportsExhausted() {
        }

        @Override
        public void onFatalConnectionException() {
        }
    }

    @Immutable
    public static final class Logging
    implements ConnectionHandshakeEventListener {
        private static final Logger LOG = I18nLogger.getLogger(Logging.class);

        private Logging() {
        }

        @Override
        public void onConnection() {
            LOG.trace("Connection established");
        }

        @Override
        public void onConnectionAttempt(SessionAttributes.Transport transport) {
            LOG.debug("Attempting to connect with {}", (Object)transport);
        }

        @Override
        public void onTransportsExhausted() {
            LOG.trace("All transports have been attempted");
        }

        @Override
        public void onFatalConnectionException() {
            LOG.debug("A non-retriable response was received from the server");
        }
    }
}

