/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.services.definition;

import com.pushtechnology.diffusion.command.services.ServiceDefinition;
import java.util.Optional;

public abstract class ServiceDefinitionImpl<C, R>
implements ServiceDefinition<C, R> {
    private final int serviceID;
    private final String serviceName;
    private final String deprecated;
    private final String journable;

    public ServiceDefinitionImpl(int serviceID, String serviceName, String deprecated, String journable) {
        this.serviceID = serviceID;
        this.serviceName = serviceName;
        this.deprecated = deprecated;
        this.journable = journable;
    }

    @Override
    public int getID() {
        return this.serviceID;
    }

    @Override
    public String getName() {
        return this.serviceName;
    }

    public int hashCode() {
        return this.serviceID;
    }

    @Override
    public Optional<String> getDeprecated() {
        return Optional.ofNullable(this.deprecated);
    }

    @Override
    public String getJournable() {
        return this.journable;
    }

    @Override
    public boolean isJournable() {
        return Boolean.parseBoolean(this.journable);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDefinitionImpl)) {
            return false;
        }
        ServiceDefinitionImpl other = (ServiceDefinitionImpl)o;
        return other.serviceID == this.serviceID;
    }

    public String toString() {
        return String.format("%s<%d>", this.getName(), this.serviceID);
    }
}

