/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.sessionfetch;

import com.pushtechnology.diffusion.client.features.InvalidFilterException;
import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class SessionFetchQueryResult {
    public static final SessionFetchQueryResult EMPTY_SESSION_FETCH_RESULT = new SessionFetchQueryResult(Collections.emptyList(), 0);
    private final List<SessionInfo> theSessions;
    private final int theTotalSelected;
    private final List<ErrorReport> theErrors;

    public SessionFetchQueryResult(List<SessionInfo> sessions, int totalSelected) {
        this.theSessions = sessions;
        this.theTotalSelected = totalSelected;
        this.theErrors = Collections.emptyList();
    }

    public SessionFetchQueryResult(List<ErrorReport> errors) {
        this.theSessions = Collections.emptyList();
        this.theTotalSelected = 0;
        this.theErrors = errors;
    }

    public List<SessionInfo> sessions() {
        return this.theSessions;
    }

    public int totalSelected() {
        return this.theTotalSelected;
    }

    public int totalSelectedChecked() throws InvalidFilterException {
        if (!this.theErrors.isEmpty()) {
            throw new InvalidFilterException("Invalid session filter", this.theErrors);
        }
        return this.theTotalSelected;
    }

    public boolean isEmpty() {
        return this.theSessions.isEmpty() && this.theTotalSelected == 0;
    }

    public boolean hasErrors() {
        return !this.theErrors.isEmpty();
    }

    public List<ErrorReport> errors() {
        return this.theErrors;
    }

    void removeStartTimes() {
        this.theSessions.forEach(s -> s.removeStartTime());
    }

    public int hashCode() {
        return Objects.hash(this.theSessions, this.theTotalSelected, this.theErrors);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionFetchQueryResult other = (SessionFetchQueryResult)obj;
        return this.theTotalSelected == other.theTotalSelected && Objects.equals(this.theSessions, other.theSessions) && Objects.equals(this.theErrors, other.theErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("SessionFetchQueryResult [sessions=").append(this.theSessions).append(", total=").append(this.theTotalSelected).append(", Errors=").append(this.theErrors).append(']');
        return sb.toString();
    }

    @ThreadSafe
    public static final class SessionInfo
    implements Comparable<SessionInfo> {
        @GuardedBy(value="this")
        private volatile Long theStartTime;
        private final Map<String, String> theProperties;

        public SessionInfo(Long startTime, Map<String, String> properties) {
            this.theStartTime = startTime;
            this.theProperties = properties;
        }

        private void removeStartTime() {
            this.theStartTime = null;
        }

        public Long getStartTime() {
            return this.theStartTime;
        }

        public Map<String, String> getProperties() {
            return this.theProperties;
        }

        @Override
        public int compareTo(SessionInfo o) {
            return Long.compare(this.theStartTime, o.theStartTime);
        }

        public int hashCode() {
            return Objects.hash(this.theStartTime, this.theProperties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SessionInfo other = (SessionInfo)obj;
            return Objects.equals(this.theStartTime, other.theStartTime) && this.theProperties.equals(other.theProperties);
        }

        public String toString() {
            return "SessionInfo [Start time=" + this.theStartTime + ", Properties=" + String.valueOf(this.theProperties) + "]";
        }
    }

    @Immutable
    public static final class Merger
    implements BinaryOperator<SessionFetchQueryResult> {
        private final SessionFetchQuery theQuery;

        public Merger(SessionFetchQuery query) {
            this.theQuery = query;
        }

        public SessionFetchQueryResult finalise(SessionFetchQueryResult result1, SessionFetchQueryResult result2) {
            SessionFetchQueryResult result = this.apply(result1, result2);
            if (!this.theQuery.requiresStartTime()) {
                result.removeStartTimes();
            }
            return result;
        }

        @Override
        public SessionFetchQueryResult apply(SessionFetchQueryResult result1, SessionFetchQueryResult result2) {
            List<SessionInfo> allSessions;
            if (result1.isEmpty()) {
                return result2;
            }
            if (result2.isEmpty()) {
                return result1;
            }
            List<SessionInfo> sessions1 = result1.sessions();
            List<SessionInfo> sessions2 = result2.sessions();
            if (sessions1.isEmpty()) {
                allSessions = sessions2;
            } else if (sessions2.isEmpty()) {
                allSessions = sessions1;
            } else {
                allSessions = new ArrayList<SessionInfo>(sessions1.size() + sessions2.size());
                allSessions.addAll(sessions1);
                allSessions.addAll(sessions2);
                Collections.sort(allSessions);
            }
            return this.theQuery.constrainedResult(allSessions, result1.totalSelected() + result2.totalSelected());
        }
    }
}

