/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.send;

import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import net.jcip.annotations.Immutable;

@Immutable
public final class MessagingSendRequest {
    private final String path;
    private final DataType<?> requestDataType;
    private final IBytes request;

    public MessagingSendRequest(String path, DataType<?> dataType, IBytes request) {
        this.path = path;
        this.requestDataType = dataType;
        this.request = request;
    }

    public String getPath() {
        return this.path;
    }

    public DataType<?> getDataType() {
        return this.requestDataType;
    }

    public IBytes getRequest() {
        return this.request;
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.requestDataType.hashCode();
        result = 31 * result + this.request.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessagingSendRequest)) {
            return false;
        }
        MessagingSendRequest other = (MessagingSendRequest)o;
        return this.path.equals(other.path) && this.requestDataType == other.requestDataType && this.request.equals(other.request);
    }

    public String toString() {
        return String.format("%s[%s, %s, %s]", this.getClass().getSimpleName(), this.path, this.requestDataType.getTypeName(), this.request);
    }
}

