/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.security;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.client.types.impl.CredentialsSerialiser;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.security.ChangePrincipalRequest;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="change-principal-request", valueType=ChangePrincipalRequest.class)
public class ChangePrincipalRequestSerialiser
extends AbstractSerialiser<ChangePrincipalRequest> {
    private final CredentialsSerialiser credentialsSerialiser;

    public ChangePrincipalRequestSerialiser(CredentialsSerialiser credentialsSerialiser) {
        this.credentialsSerialiser = credentialsSerialiser;
    }

    @Override
    protected ChangePrincipalRequest readUnchecked(InputStream in) throws IOException {
        String principal = EncodedDataCodec.readString(in);
        Credentials credentials = (Credentials)this.credentialsSerialiser.read(in);
        return new ChangePrincipalRequest(principal, credentials);
    }

    @Override
    public void write(OutputStream out, ChangePrincipalRequest value) throws IOException {
        EncodedDataCodec.writeString(out, value.getPrincipal());
        this.credentialsSerialiser.write(out, value.getCredentials());
    }
}

