/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.management;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.management.JmxFetchResponse;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.types.ErrorReasonSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol20-jmx-fetch-response", valueType=JmxFetchResponse.class)
public final class Protocol20JmxFetchResponseSerialiser
extends AbstractSerialiser<JmxFetchResponse> {
    private final ErrorReasonSerialiser errorReasonSerialiser;

    public Protocol20JmxFetchResponseSerialiser(ErrorReasonSerialiser errorReasonSerialiser) {
        this.errorReasonSerialiser = errorReasonSerialiser;
    }

    @Override
    protected JmxFetchResponse readUnchecked(InputStream in) throws IOException {
        Map<String, JmxFetchResponse.JmxResultWrapper> clusterJmxResponses = Protocol20JmxFetchResponseSerialiser.readMap(in, EncodedDataCodec::readString, this::readResultWrapper);
        return new JmxFetchResponse(clusterJmxResponses);
    }

    protected JmxFetchResponse.JmxResultWrapper readResultWrapper(InputStream in) throws IOException {
        switch (EncodedDataCodec.readByte(in)) {
            case 0: {
                return new JmxFetchResponse.JmxResultWrapper(IBytes.toIBytes(EncodedDataCodec.readByteArray(in)));
            }
        }
        return new JmxFetchResponse.JmxResultWrapper((ErrorReason)this.errorReasonSerialiser.read(in));
    }

    @Override
    public void write(OutputStream out, JmxFetchResponse response) throws IOException {
        Protocol20JmxFetchResponseSerialiser.writeMap(out, EncodedDataCodec::writeString, this::writeResultWrapper, response.getMap());
    }

    protected void writeResultWrapper(OutputStream out, JmxFetchResponse.JmxResultWrapper resultWrapper) throws IOException {
        if (resultWrapper.hasResult()) {
            EncodedDataCodec.writeByte(out, (byte)0);
            EncodedDataCodec.writeByteArray(out, IBytes.toByteArray(resultWrapper.getBytes()));
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            this.errorReasonSerialiser.write(out, resultWrapper.getErrorReason());
        }
    }
}

