/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.management;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.ErrorReasonException;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class JmxFetchResponse {
    private final Map<String, JmxResultWrapper> serverJmxResponses;

    public JmxFetchResponse(Map<String, JmxResultWrapper> serverJmxResponses) {
        this.serverJmxResponses = serverJmxResponses;
    }

    public JmxFetchResponse() {
        this.serverJmxResponses = new HashMap<String, JmxResultWrapper>();
    }

    public Map<String, JmxResultWrapper> getMap() {
        return this.serverJmxResponses;
    }

    public void put(String key, IBytes value) {
        this.serverJmxResponses.put(key, new JmxResultWrapper(value));
    }

    public void put(String key, ErrorReason errorReason) {
        this.serverJmxResponses.put(key, new JmxResultWrapper(errorReason));
    }

    public IBytes getUniqueValue() {
        if (this.serverJmxResponses.size() != 1) {
            throw new IllegalStateException("getUniqueValue called on non-single-value JMX fetch response");
        }
        JmxResultWrapper result = this.serverJmxResponses.values().iterator().next();
        if (!result.hasResult()) {
            throw new ErrorReasonException(result.getErrorReason());
        }
        return result.getBytes();
    }

    public int hashCode() {
        return this.serverJmxResponses.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmxFetchResponse other = (JmxFetchResponse)obj;
        return this.serverJmxResponses == other.serverJmxResponses || this.serverJmxResponses.equals(other.serverJmxResponses);
    }

    public String toString() {
        return "ClusterJMXFetchResponse [serverJmxResponses=" + String.valueOf(this.serverJmxResponses) + "]";
    }

    public static class JmxResultWrapper {
        private final IBytes bytes;
        private final ErrorReason errorReason;

        JmxResultWrapper(IBytes bytes) {
            this.bytes = bytes;
            this.errorReason = null;
        }

        JmxResultWrapper(ErrorReason errorReason) {
            this.bytes = null;
            this.errorReason = errorReason;
        }

        public boolean hasResult() {
            return this.bytes != null;
        }

        public IBytes getBytes() {
            return this.bytes;
        }

        public ErrorReason getErrorReason() {
            return this.errorReason;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bytes == null ? 0 : this.bytes.hashCode());
            result = 31 * result + (this.errorReason == null ? 0 : this.errorReason.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JmxResultWrapper other = (JmxResultWrapper)obj;
            if (this.bytes == null ? other.bytes != null : !this.bytes.equals(other.bytes)) {
                return false;
            }
            return !(this.errorReason == null ? other.errorReason != null : !this.errorReason.equals(other.errorReason));
        }

        public String toString() {
            return "JmxResultWrapper [bytes=" + String.valueOf(this.bytes) + ", errorReason=" + String.valueOf(this.errorReason) + "]";
        }
    }
}

