/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.log;

import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.java7.Java7;
import net.jcip.annotations.Immutable;

@Immutable
public final class LogEntriesResponse {
    private final long firstEntry;
    private final long entryCount;
    private final long fileId;
    private final long maxEntriesAvailable;
    private final IBytes entries;
    private final long firstLineNumber;

    public LogEntriesResponse(long firstEntry, long entryCount, long fileId, long maxEntriesAvailable, long firstLineNumber, IBytes entries) {
        this.firstEntry = firstEntry;
        this.entryCount = entryCount;
        this.fileId = fileId;
        this.maxEntriesAvailable = maxEntriesAvailable;
        this.firstLineNumber = firstLineNumber;
        this.entries = entries;
    }

    public long getFirstEntry() {
        return this.firstEntry;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getMaxEntriesAvailable() {
        return this.maxEntriesAvailable;
    }

    public long getFirstLineNumber() {
        return this.firstLineNumber;
    }

    public IBytes getEntries() {
        return this.entries;
    }

    public int hashCode() {
        int result = Java7.longHashCode(this.firstEntry);
        result = 31 * result + Java7.longHashCode(this.entryCount);
        result = 31 * result + Java7.longHashCode(this.fileId);
        result = 31 * result + Java7.longHashCode(this.maxEntriesAvailable);
        result = 31 * result + Java7.longHashCode(this.firstLineNumber);
        result = 31 * result + Java7.longHashCode(this.entryCount);
        result = 31 * result + this.entries.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogEntriesResponse other = (LogEntriesResponse)obj;
        return this.firstEntry == other.firstEntry && this.entryCount == other.entryCount && this.fileId == other.fileId && this.maxEntriesAvailable == other.maxEntriesAvailable && this.firstLineNumber == other.firstLineNumber && this.entries.equals(other.entries);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("LogEntriesResponse [firstEntry=").append(this.firstEntry).append(", entryCount=").append(this.entryCount).append(", fileId=").append(this.fileId).append(", maxEntriesAvailable=").append(this.maxEntriesAvailable).append(", firstLineNumber=").append(this.firstLineNumber).append(", entries=");
        this.entries.appendHex(sb, 8);
        sb.append(']');
        return sb.toString();
    }
}

