/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway.status;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.commands.gateway.status.GatewayStatusItem;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayStatusItemSerialiser
extends AbstractSerialiser<Gateway.StatusItem> {
    private static final EnumConverter<Gateway.StatusItem.Level> LEVEL_CONVERTER = new EnumConverter.Builder<Gateway.StatusItem.Level>(Gateway.StatusItem.Level.class).bimap(0, Gateway.StatusItem.Level.GREEN).bimap(1, Gateway.StatusItem.Level.AMBER).bimap(2, Gateway.StatusItem.Level.RED).build();

    @Override
    protected Gateway.StatusItem readUnchecked(InputStream in) throws IOException {
        return new GatewayStatusItem(LEVEL_CONVERTER.fromByte(EncodedDataCodec.readByte(in)), Instant.ofEpochMilli(EncodedDataCodec.readInt64(in)), EncodedDataCodec.readString(in), EncodedDataCodec.readString(in));
    }

    @Override
    public void write(OutputStream out, Gateway.StatusItem value) throws IOException {
        EncodedDataCodec.writeByte(out, LEVEL_CONVERTER.toByte(value.getLevel()));
        EncodedDataCodec.writeInt64(out, value.getTimestamp().toEpochMilli());
        EncodedDataCodec.writeString(out, value.getTitle());
        EncodedDataCodec.writeString(out, value.getDescription());
    }
}

