/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway.services;

import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.InvokeServiceOperationRequest;
import com.pushtechnology.diffusion.command.commands.gateway.services.ServiceIdSerialiser;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class InvokeServiceOperationRequestSubSerialiser
implements GatewayRequestSubSerialiser<InvokeServiceOperationRequest> {
    private final ServiceIdSerialiser theServiceIdSerialiser;

    public InvokeServiceOperationRequestSubSerialiser(ServiceIdSerialiser serviceIdSerialiser) {
        this.theServiceIdSerialiser = serviceIdSerialiser;
    }

    @Override
    public void completeWrite(OutputStream out, InvokeServiceOperationRequest request) throws IOException {
        this.theServiceIdSerialiser.write(out, request.getServiceId());
        EncodedDataCodec.writeString(out, request.getOperationName());
        String input = request.getInput();
        if (input == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, input);
        }
    }

    @Override
    public InvokeServiceOperationRequest completeRead(InputStream in) throws IOException {
        String input;
        Gateway.ServiceId serviceId = (Gateway.ServiceId)this.theServiceIdSerialiser.read(in);
        String operationName = EncodedDataCodec.readString(in);
        byte option = EncodedDataCodec.readByte(in);
        if (option == 0) {
            input = null;
        } else if (option == 1) {
            input = EncodedDataCodec.readString(in);
        } else {
            throw new IOException("Invalid option " + option);
        }
        return new InvokeServiceOperationRequest(serviceId, operationName, input);
    }
}

