/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequestSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.session.impl.InternalSessionId;
import com.pushtechnology.diffusion.session.impl.SessionIdSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-client-request", valueType=GatewayClientRequest.class)
public class GatewayClientRequestSerialiser
extends AbstractSerialiser<GatewayClientRequest> {
    private final SessionIdSerialiser theSessionIdSerialiser;
    private final GatewayRequestSerialiser theGatewayRequestSerialiser;

    public GatewayClientRequestSerialiser(SessionIdSerialiser sessionIdSerialiser, GatewayRequestSerialiser gatewayRequestSerialiser) {
        this.theSessionIdSerialiser = sessionIdSerialiser;
        this.theGatewayRequestSerialiser = gatewayRequestSerialiser;
    }

    @Override
    public void write(OutputStream out, GatewayClientRequest clientRequest) throws IOException {
        this.theSessionIdSerialiser.write(out, clientRequest.getSessionId());
        this.theGatewayRequestSerialiser.write(out, clientRequest.getRequest());
    }

    @Override
    protected GatewayClientRequest readUnchecked(InputStream in) throws IOException {
        InternalSessionId sessionId = (InternalSessionId)this.theSessionIdSerialiser.read(in);
        GatewayRequest request = (GatewayRequest)this.theGatewayRequestSerialiser.read(in);
        return new GatewayClientRequest(sessionId, request);
    }
}

