/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.gateway.control.GatewayControl;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayClientKey
implements GatewayControl.ClientKey,
Journable {
    public static final char SEPARATOR = '#';
    private final String theType;
    private final String theId;

    public GatewayClientKey(String type, String id) {
        this.theType = type;
        this.theId = id;
    }

    @Override
    public String getType() {
        return this.theType;
    }

    @Override
    public String getId() {
        return this.theId;
    }

    public String toStringKey() {
        return this.theType + "#" + this.theId;
    }

    public int hashCode() {
        return Objects.hash(this.theType, this.theId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GatewayClientKey)) {
            return false;
        }
        GatewayClientKey other = (GatewayClientKey)obj;
        return this.theType.equals(other.theType) && this.theId.equals(other.theId);
    }

    public String toString() {
        return "Gateway Client Key [Type=" + this.theType + ", Id=" + this.theId + "]";
    }

    public static GatewayClientKey fromString(String key) {
        int index = key.indexOf(35);
        if (index == -1) {
            throw new IllegalArgumentException("key does not contain separator");
        }
        return new GatewayClientKey(key.substring(0, index), key.substring(index + 1));
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(2);
        context.put("type", this.theType);
        context.put("id", this.theId);
        return context;
    }
}

