/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientDetailListRequest;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.common.StringSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-client-detail-list-request", valueType=GatewayClientDetailListRequest.class)
public class GatewayClientDetailListRequestSerialiser
extends AbstractSerialiser<GatewayClientDetailListRequest> {
    private final StringSerialiser stringSerialiser = new StringSerialiser();

    @Override
    public void write(OutputStream out, GatewayClientDetailListRequest clientDetailListRequest) throws IOException {
        Set<String> types = clientDetailListRequest.getTypes();
        if (types == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            GatewayClientDetailListRequestSerialiser.writeCollection(out, this.stringSerialiser, types);
        }
        Set<String> ids = clientDetailListRequest.getIds();
        if (ids == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            GatewayClientDetailListRequestSerialiser.writeCollection(out, this.stringSerialiser, ids);
        }
    }

    @Override
    protected GatewayClientDetailListRequest readUnchecked(InputStream in) throws IOException {
        HashSet<String> ids;
        HashSet<String> types;
        byte typeOption = EncodedDataCodec.readByte(in);
        if (typeOption == 0) {
            types = null;
        } else if (typeOption == 1) {
            types = new HashSet<String>(GatewayClientDetailListRequestSerialiser.readList(in, this.stringSerialiser));
        } else {
            throw new IOException("Invalid type option " + typeOption);
        }
        byte idOption = EncodedDataCodec.readByte(in);
        if (idOption == 0) {
            ids = null;
        } else if (idOption == 1) {
            ids = new HashSet<String>(GatewayClientDetailListRequestSerialiser.readList(in, this.stringSerialiser));
        } else {
            throw new IOException("Invalid id option " + idOption);
        }
        return new GatewayClientDetailListRequest(types, ids);
    }
}

