/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.fetch.AbstractFetchQuerySerialiser;
import com.pushtechnology.diffusion.command.commands.fetch.FetchQuery;
import com.pushtechnology.diffusion.command.commands.fetch.FetchRange;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol28-fetch-query", valueType=FetchQuery.class)
public class Protocol28FetchQuerySerialiser
extends AbstractFetchQuerySerialiser {
    @Override
    public void write(OutputStream out, FetchQuery query) throws IOException {
        super.write(out, query);
        EncodedDataCodec.writeInt32(out, query.getDeepBranchDepth());
        EncodedDataCodec.writeInt32(out, query.getDeepBranchLimit());
        EncodedDataCodec.writeBoolean(out, query.isWithUnpublishedDelayedTopics());
        EncodedDataCodec.writeBoolean(out, query.isWithSizes());
    }

    @Override
    protected FetchQuery completeRead(InputStream in, String selector, FetchRange range, Set<TopicType> topicTypes, boolean withValues, boolean withProperties, int limit, int maximumResultSize) throws IOException {
        int deepBranchDepth = EncodedDataCodec.readInt32(in);
        int deepBranchLimit = EncodedDataCodec.readInt32(in);
        boolean withUnpublishedDelayedTopics = EncodedDataCodec.readBoolean(in);
        boolean withSizes = EncodedDataCodec.readBoolean(in);
        return new FetchQuery(selector, range, topicTypes, withValues, withProperties, limit, maximumResultSize, deepBranchDepth, deepBranchLimit, withUnpublishedDelayedTopics, withSizes);
    }
}

