/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.topics.details.impl.TopicTypeCodes;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicResult;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicSizeInfo;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="fetch-topic-result", valueType=FetchTopicResult.class)
public class FetchTopicResultSerialiser
extends AbstractSerialiser<FetchTopicResult> {
    @Override
    public void write(OutputStream out, FetchTopicResult result) throws IOException {
        EncodedDataCodec.writeString(out, result.path());
        EncodedDataCodec.writeByte(out, TopicTypeCodes.TOPIC_TYPES_WITH_UNKNOWN_CODE.converter().toByte(result.type()));
        IBytes value = result.value();
        if (value == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeByteArray(out, value.toByteArrayInternal());
        }
        EncodedDataCodec.writeInt32(out, result.propertiesIndex());
    }

    @Override
    protected FetchTopicResult readUnchecked(InputStream in) throws IOException {
        return new FetchTopicResult(this.readPath(in), this.readType(in), this.readValue(in), this.readPropertiesIndex(in), FetchTopicSizeInfo.NO_TOPIC_SIZE_INFO);
    }

    final String readPath(InputStream in) throws IOException {
        return EncodedDataCodec.readString(in);
    }

    final TopicType readType(InputStream in) throws IOException {
        return TopicTypeCodes.TOPIC_TYPES_WITH_UNKNOWN_CODE.converter().fromByte(EncodedDataCodec.readByte(in), TopicType.UNKNOWN_TOPIC_TYPE);
    }

    final IBytes readValue(InputStream in) throws IOException {
        byte valueOption = EncodedDataCodec.readByte(in);
        IBytes value = valueOption == 0 ? null : IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return value;
    }

    final int readPropertiesIndex(InputStream in) throws IOException {
        return EncodedDataCodec.readInt32(in);
    }
}

