/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.client.topics.details.impl.TopicTypeCodes;
import com.pushtechnology.diffusion.command.commands.fetch.FetchQuery;
import com.pushtechnology.diffusion.command.commands.fetch.FetchRange;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;

public abstract class AbstractFetchQuerySerialiser
extends AbstractSerialiser<FetchQuery> {
    @Override
    public void write(OutputStream out, FetchQuery query) throws IOException {
        EncodedDataCodec.writeString(out, query.getSelector());
        AbstractFetchQuerySerialiser.writeRange(out, query.getRange());
        EncodedDataCodec.writeInt64(out, TopicTypeCodes.TOPIC_TYPES_WITH_UNKNOWN_CODE.converter().setToLong(query.getTopicTypes()));
        EncodedDataCodec.writeBoolean(out, query.isWithValues());
        EncodedDataCodec.writeBoolean(out, query.isWithProperties());
        EncodedDataCodec.writeInt32(out, query.getLimit());
        EncodedDataCodec.writeInt32(out, query.getMaximumResultSize());
    }

    private static void writeRange(OutputStream out, FetchRange range) throws IOException {
        if (FetchRange.UNBOUNDED.equals(range)) {
            EncodedDataCodec.writeByte(out, (byte)0);
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            AbstractFetchQuerySerialiser.writeLimit(out, range.from());
            AbstractFetchQuerySerialiser.writeLimit(out, range.to());
        }
    }

    private static void writeLimit(OutputStream out, FetchRange.Limit limit) throws IOException {
        if (limit == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, limit.path());
            EncodedDataCodec.writeBoolean(out, limit.includesPath());
        }
    }

    @Override
    protected final FetchQuery readUnchecked(InputStream in) throws IOException {
        String selector = EncodedDataCodec.readString(in);
        FetchRange range = AbstractFetchQuerySerialiser.readRange(in);
        Set<TopicType> topicTypes = TopicTypeCodes.TOPIC_TYPES.converter().longToSet(EncodedDataCodec.readInt64(in), TopicType.UNKNOWN_TOPIC_TYPE);
        boolean withValues = EncodedDataCodec.readBoolean(in);
        boolean withProperties = EncodedDataCodec.readBoolean(in);
        int limit = EncodedDataCodec.readInt32(in);
        int maximumResultSize = EncodedDataCodec.readInt32(in);
        return this.completeRead(in, selector, range, topicTypes, withValues, withProperties, limit, maximumResultSize);
    }

    protected abstract FetchQuery completeRead(InputStream var1, String var2, FetchRange var3, Set<TopicType> var4, boolean var5, boolean var6, int var7, int var8) throws IOException;

    private static FetchRange readRange(InputStream in) throws IOException {
        FetchRange.Limit fromLimit = AbstractFetchQuerySerialiser.readLimit(in);
        FetchRange.Limit toLimit = AbstractFetchQuerySerialiser.readLimit(in);
        if (fromLimit == null && toLimit == null) {
            return FetchRange.UNBOUNDED;
        }
        return new FetchRange(fromLimit, toLimit);
    }

    private static FetchRange.Limit readLimit(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 0) {
            return null;
        }
        return new FetchRange.Limit(EncodedDataCodec.readString(in), EncodedDataCodec.readBoolean(in));
    }
}

